% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{import_plink.pedmap}
\alias{import_plink.pedmap}
\title{import_plink.pedmap}
\usage{
import_plink.pedmap(root = root,
                      sep_ped = "\t", sep_map = "\t",
                      pedfile = pedfile, mapfile = mapfile)
}
\arguments{
\item{root}{this function only support p.link file
format stored in "map" and "ped" format, the file names after removed suffix
should be same with each other.}

\item{sep_ped}{a character indicate the separation of ped file}

\item{sep_map}{a character indicate the separation of map file}

\item{pedfile, mapfile}{if \code{root} is missing then \code{pedfile} and \code{mapfile} are needed}
}
\value{
list, contains map information stored in data.frame and ped
information stored in data.frame
}
\description{
used for import small p.link file stored in map and ped format
}
\examples{
\donttest{
   pedfile <- system.file("extdata",
                          "snp3kvars-CHR8-25947258-25951166-plink.ped",
                          package = "geneHapR")
   mapfile <- system.file("extdata",
                          "snp3kvars-CHR8-25947258-25951166-plink.map",
                          package = "geneHapR")
   p.link <- import_plink.pedmap(pedfile = pedfile, mapfile = mapfile,
                                 sep_map = "\t", sep_ped = "\t")
   p.link <- filter_plink.pedmap(p.link, mode = "POS",
                                 Chr = "chr08", start = 25948004,
                                 end = 25949944)
   hapResult <- plink.pedmap2hap(p.link, hapPrefix = "H",
                                 hyb_remove = TRUE,
                                 na.drop = TRUE)
}
}
