# Geiger

[![Build Status](https://travis-ci.org/mwpennell/geiger-v2.svg?branch=master)](https://travis-ci.org/mwpennell/geiger-v2)

## Major features

geiger is a (growing) collection of methods developed over the years by many researchers.
Here is a a non-comprehensive list of methods:

* Fit continuous models of evolution (BM, OU, EB, Pagel models, etc.)
* Fit discrete models of evolution (Mk and variants)
* [Identify shifts in the rate of continuous trait evolution](https://onlinelibrary.wiley.com/doi/10.1111/j.1558-5646.2011.01401.x/abstract)
* [Fit continuous trait models to unresolved data using ABC](https://onlinelibrary.wiley.com/doi/10.1111/j.1558-5646.2011.01474.x/abstract)
* [Use fossil information to improve macroevolutionary inference](https://onlinelibrary.wiley.com/doi/10.1111/j.1558-5646.2012.01723.x/abstract)
* [Identify shifts in the rate of diversification](https://www.pnas.org/doi/abs/10.1073/pnas.0811087106}
* [Posterior predictive model assessment](http://sysbio.oxfordjournals.org/content/63/3/293)
* [Time-scaling large phylogenies with 'congruification'](https://onlinelibrary.wiley.com/doi/10.1111/2041-210X.12051/full)

## Citing geiger

If you use geiger, please cite:

Pennell, M.W., J.M. Eastman, G.J. Slater, J.W. Brown, J.C. Uyeda, R.G. FitzJohn, M.E. Alfaro, and L.J. Harmon. 2014. geiger v2.0: an expanded suite of methods for fitting macroevolutionary models to phylogenetic trees. Bioinformatics 30:2216-2218.

in addition to the original papers describing the methods.

## Acknowledgements

We thank the CRAN team for help cleaning up our package errors.

## Feedback

We are always looking to improve geiger. If you have comments/questions/ideas, we encourage you to get in contact by posting an issue or making a pull request.
