% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_geelite.R,
%   R/run_geelite._halfgoogleimportR.R
\name{get_images}
\alias{get_images}
\title{Retrieve Images and Related Information}
\usage{
get_images(task, mode, cases, dataset, band, regions_new, latest_date)

get_images(task, mode, cases, dataset, band, regions_new, latest_date)
}
\arguments{
\item{task}{[mandatory] (list) Session task specifying parameters for data
collection.}

\item{mode}{[mandatory] (character) Mode of data extraction. Currently
supports \code{"local"} or \code{"drive"} (for larger exports via Google
Drive). Defaults to \code{"local"}.}

\item{cases}{[mandatory] (integer) Type of data collection request
(\code{1}: All build, \code{2}: All update, \code{3}: Mixed).}

\item{dataset}{[mandatory] (character) Name of the GEE dataset.}

\item{band}{[mandatory] (character) Name of the band.}

\item{latest_date}{[mandatory] (date) The most recent data available in the
related SQLite table. Set to \code{NULL} during the (re)building procedure.}
}
\value{
List containing retrieved images and related information as follows:
\describe{
 \item{$build}{Images for the building procedure}
 \item{$update}{Images for the updating procedure}
 \item{$batch_size}{Batch size}
 \item{$skip_band}{TRUE if 'band' is up-to-date and can be skipped}
 \item{$skip_update}{TRUE if 'band' is up-to-date but cannot be skipped}
}

List containing retrieved images and related information as follows:
\describe{
 \item{$build}{Images for the building procedure}
 \item{$update}{Images for the updating procedure}
 \item{$batch_size}{Batch size}
 \item{$skip_band}{TRUE if 'band' is up-to-date and can be skipped}
 \item{$skip_update}{TRUE if 'band' is up-to-date but cannot be skipped}
}
}
\description{
Retrieves images and related information from Google Earth Engine (GEE)
based on the specified session task.

Retrieves images and related information from Google Earth Engine (GEE)
based on the specified session task.
}
\keyword{internal}
