% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_fn.R
\name{distance}
\alias{distance}
\title{Create distance layer.}
\usage{
distance(longlat, layers, type = "minimum")
}
\arguments{
\item{longlat}{Matrix of longitude and latitude or eastness and northness (two columns in this order) of species occurrence records.}

\item{layers}{Raster* object as defined by package raster to serve as model to create distance layer.}

\item{type}{text string indicating whether the output should be the "minimum", "average" or "mcp" distance to all records. "mcp" means the distance to the minimum convex polygon encompassing all records.}
}
\value{
A RasterLayer object.
}
\description{
Creates a layer depicting distances to records using the minimum, average, distance to the minimum convex polygon or distance taking into account a cost surface.
}
\details{
Using distance to records in models may help limiting the extrapolation of the predicted area much beyond known areas.
}
\examples{
userpar <- par(no.readonly = TRUE) 
layers = gecko.examples("gecko.layers")
alt = layers[[3]]
records = gecko.examples("gecko.records")
par(mfrow=c(3,2))
terra::plot(alt)
points(records)
terra::plot(distance(records, alt))
terra::plot(distance(records, alt, type = "average"))
par(userpar)
}
