% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_chol.R
\name{solve_chol}
\alias{solve_chol}
\alias{solve.chol}
\title{Solve using cholesky decomposition}
\usage{
solve_chol(a, b, ...)

\method{solve}{chol}(a, b, ...)
}
\arguments{
\item{a}{The cholesky decomposition of a positive
definite matrix.}

\item{b}{A numeric or complex vector or matrix giving the
right-hand side(s) of the linear system. If missing,
\code{b} is taken to be an identity matrix and solve
will return the inverse of \code{a}.}

\item{...}{Currently unused.}
}
\description{
\code{solve_chol} solves a system of equations using the
cholesky decomposition of a positive definite matrix
\code{A}, i.e., using \code{a = chol(A)}.
}
\details{
Note: Unless you have good reason to suspect that the
cholesky decomposition of your matrix will be stable, it
is recommended that you use \code{\link[base]{solve}} or
perform the solve using the \code{\link[base]{qr}}
decomposition.
}
\examples{
set.seed(10)
# create positive definite matrix a
a = crossprod(matrix(rnorm(25^2), nrow = 25))
# create vector x and matrix b
# x can be used to check the stability of the solution
x = matrix(rnorm(25))
b = a \%*\% x

# standard solve
x1 = solve(a, b)
all.equal(x, x1)

# solve using cholesky decomposition
chola = chol(a)
x2 = solve_chol(chola, b)
all.equal(x, x2)

# solve using qr decomposition
qra = qr(a)
x3 = solve.qr(qra, b)
all.equal(x, x3)

# compare direct inversion
ai1 = solve(a)
ai2 = solve_chol(chola) #using cholesky decomposition
all.equal(ai1, ai2) # should be TRUE
}
\seealso{
\code{\link[base]{solve}},
  \code{\link[base]{chol}}, \code{\link[base]{qr}},
  \code{\link[base]{solve.qr}}
}
\author{
Joshua French
}
