% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.R
\name{raster_write}
\alias{raster_write}
\title{Draw/preview a raster to a png file}
\usage{
raster_write(x, path, width = 480, height = 480, interpolate = FALSE)
}
\arguments{
\item{x}{A raster object}

\item{path}{name of the file to create}

\item{width, height}{Width and height in pixels.}

\item{interpolate}{A logical value indicating whether to linearly
interpolate the image.}
}
\description{
Draw/preview a raster to a png file
}
\examples{
r <- as.raster(matrix(hcl(0, 80, seq(50, 80, 10)),
 nrow = 4, ncol = 5))
raster_write(x = r, path = "raster.png", width = 50, height = 50)
}

