\name{niinorm}
\alias{niinorm}
\concept{Utility}
\title{Normalization of Principal Diffusion Directions}
\description{
\code{niinorm} normalizes Principal Diffusion Directions (PDDs) in NIfTI files.
The unnormalized PDD values produced by \code{gqi.odfvmf} retain information about the estimated von Mises-Fisher parameters at each voxel, which are useful in probabilistic tractography. 
On the other hand, normalized PDD values are useful for visualization and seed mask creation, namely using the \sQuote{FSL/fslview} tool.
}

\usage{
niinorm(srcdir=tempfile(), filename="data_V1", savedir=tempdir())
}

\arguments{
\item{srcdir}{ directory where loading files are located (default: \code{tempdir()}.) }
\item{filename}{ name of the NIfTI file with PDD values to be normalized (default: \file{"data_V1")}.) }
\item{savedir}{ directory for saving processed results (default: \code{tempdir()}.) }
}

\value{
\code{niinorm} accepts NIfTI files with incorporated PDD values as produced by \code{gqi.odfvmf},
 and outputs NIfTI files with normalized PDD values in the unit sphere. 
The output NIfTI filenames receive the suffix 'n', e.g., \file{data_V1n} and  \file{data_V2n}.
}


\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa,
  Faculdade de Ciencias e Tecnologia, Portugal, \email{afs at fct.unl.pt}
}

\seealso{
  \code{\link{gqi.odfvmf}}
}

\examples{
\dontrun{
## Example using the PDD files in gdimap
## normalize vector data generated by vMF functions
## before visualization with FSL/fslview
fi1 <- "data_V1.nii.gz"
p <- system.file(file.path("extdata", fi1), package = "gdimap")
p1 <- strsplit(p,fi1)[[1]][1]
niinorm(srcdir=p1, filename=fi1, savedir=tempdir())
fi2 <- "data_V2.nii.gz"
niinorm(srcdir=p1, filename=fi2, savedir=tempdir())
## try fslview if installed
fo1 <- file.path(tempdir(),"data_V1n.nii.gz")
fo2 <- file.path(tempdir(),"data_V2n.nii.gz")
fo3 <- file.path(p1, "data_gfa.nii.gz")
if(Sys.which("fslview") != "") system(paste("fslview", fo3, fo2, fo1, "&"))
}
}

\keyword{ utilities }

