% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_set_path_option}
\alias{vsi_set_path_option}
\title{Set a path specific option for a given path prefix}
\usage{
vsi_set_path_option(path_prefix, key, value)
}
\arguments{
\item{path_prefix}{Character string. A path prefix of a virtual file system
handler. Typically of the form \verb{/vsiXXX/bucket}.}

\item{key}{Character string. Option key.}

\item{value}{Character string. Option value. Passing \code{value = ""} (empty
string) will unset a value previously set by \code{vsi_set_path_option()}.}
}
\value{
No return value, called for side effect.
}
\description{
\code{vsi_set_path_option()} sets a path specific option for a given path
prefix. Such an option is typically, but not limited to, setting
credentials for a virtual file system.
Wrapper for \code{VSISetPathSpecificOption()} in the GDAL Common Portability
Library. Requires GDAL >= 3.6.
}
\details{
Options may also be set with \code{set_config_option()}, but
\code{vsi_set_path_option()} allows specifying them with a granularity at the
level of a file path. This makes it easier if using the same virtual file
system but with different credentials (e.g., different credentials for
buckets "/vsis3/foo" and "/vsis3/bar"). This is supported for the following
virtual file systems: /vsis3/, /vsigs/, /vsiaz/, /vsioss/, /vsiwebhdfs,
/vsiswift.
}
\note{
Setting options for a path starting with /vsiXXX/ will also apply for
/vsiXXX_streaming/ requests.

No particular care is taken to store options in RAM in a secure way.
So they might accidentally hit persistent storage if swapping occurs,
or someone with access to the memory allocated by the process may be
able to read them.
}
\seealso{
\code{\link[=set_config_option]{set_config_option()}}, \code{\link[=vsi_clear_path_options]{vsi_clear_path_options()}}
}
