% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm-perf.r
\name{gbmt_performance}
\alias{gbmt_performance}
\title{Get performance details for gbm fit}
\usage{
gbmt_performance(gbm_fit_obj, method)
}
\arguments{
\item{gbm_fit_obj}{a \code{GBMFit} created from an initial call to
\code{\link{gbmt}}.}

\item{method}{indicate the method used to estimate the optimal
number of boosting iterations. \code{method="OOB"} computes the
out-of-bag estimate and \code{method="test"} uses the test (or
validation) dataset to compute an out-of-sample
estimate. \code{method="cv"} extracts the optimal number of
iterations using cross-validation if \code{gbmt} was called with
\code{cv_folds}>1.}
}
\value{
a GBMTPerformance object, which is a number - the optimal
iteration number - with various attributes.
}
\description{
\code{gbmt_performance} estimates the optimal number of boosting
iterations from a model fit by \code{\link{gbmt}}.  The precise
method used depends on the \code{method} parameter.
}
