% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dynamic_feeds.R
\name{get_free_bike_status}
\alias{get_free_bike_status}
\title{Grab the free_bike_status feed.}
\usage{
get_free_bike_status(
  city,
  directory = NULL,
  file = "free_bike_status.rds",
  output = NULL
)
}
\arguments{
\item{city}{A character string that can be matched to a city or a url to an active 
gbfs .json feed. See [get_gbfs_cities()]  for a current list of available cities.}

\item{directory}{Optional. Path to a folder (or folder to be 
created) where the feed will be saved.}

\item{file}{Optional. The name of the file to be saved (if \code{output} 
is set to \code{"save"} or \code{"both"}), as a character string. 
Must end in \code{".rds"}.}

\item{output}{Optional. The type of output method. If left as default, this
argument is inferred from the \code{directory} argument. If 
\code{output = "save"}, the object will be saved as an .rds object at 
# the given path. If \code{output = "return"}, the output will be returned 
as a dataframe object. Setting \code{output = "both"} will do both.}
}
\value{
The output of this function depends on the argument to \code{output}
and \code{directory}. Either a saved .rds object generated from the current 
station_information feed, a dataframe object, or both. If a saved feed of
the same type already exists at the filepath, the feed will be appended to
rather than overwritten.
}
\description{
Grab a dataframe giving the geographic location and other metadata of
bikeshare bikes not parked at bikeshare stations. Metadata for this dataset
can be found at: \url{https://github.com/NABSA/gbfs/blob/master/gbfs.md}
}
\examples{
# we can grab the free bike status feed for memphis, 
# tennessee's bikeshare program in  several ways! the most 
# straightforward way is just to supply the `city` argument
# as a string:
\donttest{get_free_bike_status(city = "memphis")}

# the `city` argument can also be supplied as an
# actual URL to an active .json feed
\donttest{get_free_bike_status(city = 
"https://gbfs.bcycle.com/bcycle_memphis/free_bike_status.json",  
                     directory = tempdir())}

# if you'd like to save the output to file, supply a 
# `directory` argument. usually, though, we would supply a 
# character string (like "memphis", maybe,) for the `directory` 
# argument instead of `tempdir`.
\donttest{get_free_bike_status(city = "memphis",  
                     directory = tempdir())}
                     
# the output argument can control whether the file is
# saved and/or returned explicitly
\donttest{get_free_bike_status(city = "memphis",  
                     directory = tempdir(),
                     output = "both")}                     

}
\seealso{
[get_gbfs()] for a wrapper to call each of the \code{get_feed}
functions, [get_gbfs_cities()] for a dataframe of cities releasing gbfs
functions, and [get_which_gbfs_feeds()] for a dataframe of which feeds
are released by a given city.
}
