% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\docType{package}
\name{gapfill-package}
\alias{Gapfill-Package}
\alias{Gapfill-package}
\alias{gapfill-Package}
\alias{gapfill-package}
\title{Overview}
\description{
The package provides tools to fill-in missing values in satellite data.
It can be used to gap-fill, e.g., MODIS NDVI data and
is helpful when developing new gap-fill algorithms.
The methods are tailored to data (images) observed at equally-spaced points in time. 
This is typically the case for MODIS land surface products and AVHRR NDVI data, among others. \cr
The predictions of the missing values are based on a subset-predict procedure, i.e.,
each missing value is predicted separately by
(1) selecting subsets of the data that are in a neighborhood around the missing point and
(2) predicting the missing value based on the subset.\cr
The main function of the package is \code{\link{Gapfill}}.
}
\section{Features}{

\itemize{
\item Gap-filling can be executed in parallel. 

\item Users may define new \code{\link{Subset}} and \code{\link{Predict}} functions
and run alternative prediction algorithms with little effort.
See \link{Extend} for more information and examples.  

\item Visualization of space-time data are simplified through the \code{ggplot2}-based
function \code{\link{Image}}.
}
}
\author{
Florian Gerber, \email{florian.gerber@math.uzh.ch}.
}
\references{
F. Gerber, R. Furrer, G. Schaepman-Strub, R. de Jong, M. E. Schaepman, 2016,
Predicting missing values in spatio-temporal satellite data.
\url{http://arxiv.org/abs/1605.01038}.
}
\seealso{
\code{\link{Gapfill}}, \code{\link{Subset-Predict}}, \code{\link{Extend}}, \code{\link{Image}}.
}
\keyword{package}

