% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ultimatum.r
\name{LW}
\alias{LW}
\title{Lambert's W}
\usage{
LW(x)
}
\arguments{
\item{x}{vector of values to solve for.}
}
\value{
Solutions to Lambert's W for each value in \code{x}.
}
\description{
Solves for W in the equation \eqn{W e^W = x}{W * exp(W) = x}.
}
\details{
The function is based on the code given in Barry et al. (1995).  It is used
to calculate fitted values for the \code{\link{ultimatum}} model.

If negative values of \code{x} are supplied, \code{NaN}s will likely be
returned.
}
\examples{
x <- rexp(10)
w <- LW(x)
all.equal(x, w * exp(w))
}
\author{
Curt Signorino (\email{curt.signorino@rochester.edu})
}
\references{
D.A. Barry, P.J. Culligan-Hensley, and S.J. Barry.  1995.  "Real
Values of the W-Function."  \emph{ACM Transactions on Mathematical Software}
21(2):161--171.
}

