% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_call.R
\name{galah_call}
\alias{galah_call}
\alias{print.data_request}
\title{Start building a data query}
\usage{
galah_call(
  identify = NULL,
  filter = NULL,
  select = NULL,
  geolocate = NULL,
  group_by = NULL,
  down_to = NULL,
  ...
)

\method{print}{data_request}(x, ...)
}
\arguments{
\item{identify}{\code{data.frame}: generated by a call to \code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to \code{\link[=select_filters]{select_filters()}}}

\item{select}{\code{data.frame}: generated by a call to \code{\link[=galah_select]{galah_select()}}}

\item{geolocate}{\code{string}: generated by a call to \code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{group_by}{\code{data.frame}: generated by a call to \code{\link[=galah_group_by]{galah_group_by()}}}

\item{down_to}{\code{data.frame}: generated by a call to \code{\link[=galah_down_to]{galah_down_to()}}}

\item{...}{other function-specific request parameters}
}
\description{
To download data from the ALA (or another atlas), one must construct a data
query. This query tells the atlas API what data to download and return, as
well as how it should be filtered. The \code{galah} package enables users to
construct their data queries using piping syntax (i.e., \verb{\%>\%} from \code{magrittr},
or \verb{|>} from \code{base}). Building a data query using piping allows users to use
functions like \code{\link[=search_taxa]{search_taxa()}}, \code{\link[=galah_filter]{galah_filter()}}, \verb{[galah_select()]},
\code{\link[=galah_group_by]{galah_group_by()}}, and \code{\link[=galah_down_to]{galah_down_to()}} to specify filters for their
queries line-by-line, narrowing the results of their query.
Users then finish their query with an \code{atlas_} function to identify which
type of data they wish to download (i.e., \code{\link[=atlas_occurrences]{atlas_occurrences()}},
\code{\link[=atlas_counts]{atlas_counts()}}, \code{\link[=atlas_species]{atlas_species()}}, \code{\link[=atlas_taxonomy]{atlas_taxonomy()}} or \code{\link[=atlas_media]{atlas_media()}}).
}
\section{Examples}{


Using \code{galah_call()} with pipes allows you to build, filter
and download data queries the same way that you would wrangle your own data
with \code{dplyr} and the \code{tidyverse}. Begin your query with \code{galah_call()}, then
use either \verb{\%>\%} from \code{magrittr} or \verb{|>} from \code{base} to narrow/filter your
results line-by-line.

Find number of records of \emph{Aves} from 2001 to 2004 by year\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(magrittr)

galah_call() \%>\%
  galah_identify("Aves") \%>\%
  galah_filter(year > 2000 & year < 2005) \%>\%
  galah_group_by() \%>\%
  atlas_counts()
}\if{html}{\out{</div>}}

Download \emph{Eolophus} records from 2001 to 2004\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_config(email = "your-email@email.com")

galah_call() \%>\%
   galah_identify("Eolophus") \%>\%
  galah_filter(year > 2000 & year < 2005) \%>\%
  atlas_occurrences()
}\if{html}{\out{</div>}}

Find information for all species in \emph{Cacatuidae} family\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() \%>\%
  galah_identify("Cacatuidae") \%>\%
  atlas_species()
}\if{html}{\out{</div>}}
}

\keyword{internal}
