% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotope-high-level.R
\name{isotope_posterior_probs}
\alias{isotope_posterior_probs}
\title{compute posterior probabilities of origin given isotope values}
\usage{
isotope_posterior_probs(
  isoscape,
  ref_birds,
  assign_birds = NULL,
  isoscape_pred_column = "predkrig",
  isoscape_sd_column = "stdkrig",
  self_assign = FALSE
)
}
\arguments{
\item{isoscape}{the data frame read in from "prediction.txt" from ISOMAP. The
latitude column must be named "lat" and the longitude column must be named "long".  You have to choose
which columns to use with the parameters \code{isoscape_pred_column} and \code{isoscape_sd_column}.}

\item{ref_birds}{a data frame of reference birds. This should have (at least) columns of "ID"
(for unique identifiers for each bird), "lat", "long",
"Isotope.Value" and "Location".  The "Location" column will be used to group samples for
the Vander Zanden Rescaling.}

\item{assign_birds}{A data frame of birds whose breeding origins are to be inferred.  These must have
at a minimum the column "ID" (for uniqe identifiers for the birds) and the column "Isotope.Value". This can
be left NULL if there are no birds of unknown origin to assign (for example if you are performing cross-validation
on the ref_birds).}

\item{isoscape_pred_column}{the name of the column in \code{isoscape} to be used as the prediction (default
is "predkrig").}

\item{isoscape_sd_column}{the name of the column in \code{isoscape} to be used as the standard deviation (default
is "stdkrig").}

\item{self_assign}{if TRUE, then the birds in \code{ref_birds} will each have posterior surfaces computed for
them using a leave one out procedure (i.e. each bird in turn is left out while rescaling the precip isomap to
a tissue isomap).  Should not be TRUE if assign_birds is non NULL.}
}
\description{
This function automates the whole process described in the appendix of
Vander Zanden et al. (2014) for computing the posterior probability of
origin of an individual (or group of individuals) given its stable isotope
values, and those of a set of reference individuals, and an ISOMAP prediction
of isotope values across a landscape.
}
\details{
For details see:

Vander Zanden HB, Wunder MB, Hobson KA, Van Wilgenburg SL, Wassenaar LI, Welker JM, Bowen GJ (2014)
Contrasting assignment of migratory organisms to geographic origins using long-term versus year-specific
precipitation isotope maps. Methods in Ecology and Evolution, 5, 891-900.

And the re-explanation of that method in Ruegg et al. (2017).
}
\examples{
# obtain posterior probability rasters for the first 2 birds in the migrant_wiwa_isotopes
# data set.  This takes about 15 seconds on my laptop (most of that time is preparatory---once
# that is done, each bird goes much faster). So we don't run it here.
\dontrun{
birds2 <- isotope_posterior_probs(isoscape = isomap_job54152_prediction,
                        ref_birds = breeding_wiwa_isotopes,
                        assign_birds = migrant_wiwa_isotopes[1:2,]
                        )
}

# However, you can load the results as a saved data object to see what they look like:
birds2 <- example_isotope_posteriors


# Since the ref_birds above were separate from the migrant birds, no leave-one-out was
# performed.  Hence birds2$loo_results is NULL, and all the results are in
# birds2$regular.

# Look at the names of the resulting output for the first bird:
names(birds2$regular[[1]])

names(birds2$regular[[1]]$assignment_parameters)



# If you want to do self-assignment for a whole bunch of reference birds, it takes much longer.
# It looks like this:
\dontrun{
self_ass <- isotope_posterior_probs(isoscape = isomap_job54152_prediction,
                                    ref_birds = breeding_wiwa_isotopes,
                                    self_assign = TRUE)
}
}
