% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citest-generic.R
\name{citest-generic}
\alias{citest-generic}
\alias{ciTest}
\title{Generic function for conditional independence test}
\usage{
ciTest(x, set = NULL, ...)
}
\arguments{
\item{x}{An object for which a test for conditional independence is to be
made. See 'details' for valid types of \code{x}.}

\item{set}{A specification of the test to be made. The tests are of the form
u and v are independent condionally on S where u and v are variables and
S is a set of variables. See 'details' for details about specification of
\code{set}.}

\item{\dots}{Additional arguments to be passed on to other methods.}
}
\value{
An object of class \code{citest} (which is a list).
}
\description{
Generic function for conditional independence test. Specializes
to specific types of data.
}
\details{
\code{x} can be
\enumerate{
\item a table (an array). In this case \code{ciTest_table} is called.
\item a dataframe whose columns are numerics and factors. In this
case \code{ciTest_df} is called.
\item a list with components \code{cov} and \code{n.obs}. In this
case \code{ciTest_mvn} is called.
}

\code{set} can be
\enumerate{
\item a vector,
\item a right-hand sided
formula in which variables are separated by '+'.
}

In either case, it is tested if the first two variables in the
\code{set} are conditionally independent given the remaining
variables in \code{set}.  (Notice an abuse of the '+' operator in
the right-hand sided formula: The order of the variables does
matter.)
}
\examples{

## contingency table:
data(reinis)
## dataframe with only numeric variables:
data(carcass)
## dataframe with numeric variables and factors:
data(milkcomp1)

ciTest(cov.wt(carcass, method='ML'), set=~Fat11 + Meat11 + Fat12)
ciTest(reinis, set=~smo + phy + sys)
ciTest(milkcomp1, set=~tre + fat + pro)
}
\seealso{
\code{\link{ciTest_table}},
\code{\link{ciTest_df}},
\code{\link{ciTest_mvn}},
\code{\link{chisq.test}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
