% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcox.R
\name{rcox}
\alias{rcox}
\title{Main function for specifying RCON/RCOR models.}
\usage{
rcox(
  gm = NULL,
  vcc = NULL,
  ecc = NULL,
  type = c("rcon", "rcor"),
  method = "ipm",
  fit = TRUE,
  data = NULL,
  S = NULL,
  n = NULL,
  Kstart = NULL,
  control = list(),
  details = 1,
  trace = 0
)
}
\arguments{
\item{gm}{Generating class for a grapical Gaussian model, see
'Examples' for an illustration}

\item{vcc}{List of vertex colour classes for the model}

\item{ecc}{List of edge colour classes for the model}

\item{type}{Type of model. Default is RCON}

\item{method}{Estimation method; see 'Details' below.}

\item{fit}{Should the model be fitted}

\item{data}{A dataframe}

\item{S}{An empirical covariance matrix (as alternative to giving data
as a dataframe)}

\item{n}{The number of observations (which is needed if data is
specified as an empirical covariance matrix)}

\item{Kstart}{An initial value for K. Can be omitted.}

\item{control}{Controlling the fitting algorithms}

\item{details}{Controls the amount of output}

\item{trace}{Debugging info}
}
\value{
A model object of type 'RCOX'.
}
\description{
This is the main function for specifying and fitting
RCON/RCOR models in the package along with certain utility
functions.
}
\details{
Estimation methods:
\itemize{
\item 'ipm' (default) is iterative partial maximization
which when finished calculates the information matrix so that
approximate variances of the parameters can be obtained using vcov().
\item 'ipms' is iterative partial maximization without
calculating the information matrix. This is the fastest method.
\item 'scoring' is stabilised Fisher scoring.
\item 'matching' is score matching followed by one step with Fisher
scoring.
\item 'hybrid1' is for
internal use and should not be called directly
}
}
\examples{
data(math)
gm  = ~al:an:st
vcc = list(~me+st, ~ve+an, ~al)
ecc = list(~me:ve+me:al, ~ve:al+al:st)

m1 <- rcox(gm=gm, vcc=vcc, ecc=ecc, data=math, method='matching')
m2 <- rcox(gm=gm, vcc=vcc, ecc=ecc, data=math, method='scoring')
m3 <- rcox(gm=gm, vcc=vcc, ecc=ecc, data=math, method='ipm')

m1
m2
m3

summary(m1)
summary(m2)
summary(m3)

coef(m1)
coef(m2)
coef(m3)

vcov(m1)
vcov(m2)
vcov(m3)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
