% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndset.R
\name{genNDSet}
\alias{genNDSet}
\title{Generate a sample of nondominated points.}
\usage{
genNDSet(
  p,
  n,
  range = c(1, 100),
  random = FALSE,
  sphere = TRUE,
  planes = FALSE,
  box = FALSE,
  keepDom = FALSE,
  crit = "min",
  dubND = FALSE,
  classify = FALSE,
  ...
)
}
\arguments{
\item{p}{Dimension of the points.}

\item{n}{Number nondominated points generated.}

\item{range}{The range of the points in each dimension (a vector or matrix with \code{p} rows).}

\item{random}{Random sampling.}

\item{sphere}{Generate points on a sphere.}

\item{planes}{Generate points between two planes.}

\item{box}{Generate points in boxes.}

\item{keepDom}{Keep dominated points also.}

\item{crit}{Criteria used (a vector of min/max).}

\item{dubND}{Should duplicated non-dominated points be considered as non-dominated.}

\item{classify}{Non-dominated points are classified into supported extreme (\code{se}), supported
non-extreme (\code{sne}) and unsupported (\code{us})}

\item{...}{Further arguments passed on to \code{\link{genSample}}.}
}
\value{
A data frame with \code{p+1} columns (last one indicate if dominated or not).
}
\description{
Generate a sample of nondominated points.
}
\examples{
\donttest{
## Random
range <- matrix(c(1,100, 50, 100, 10, 50), ncol = 2, byrow = TRUE)
pts <- genNDSet(3, 5, range = range, random = TRUE, keepDom = TRUE)
head(pts)
Rfast::colMinsMaxs(as.matrix(pts[, 1:3]))
ini3D(FALSE, argsPlot3d = list(xlim = c(min(pts[,1])-2,max(pts[,1])+10),
  ylim = c(min(pts[,2])-2,max(pts[,2])+10),
  zlim = c(min(pts[,3])-2,max(pts[,3])+10)))
plotPoints3D(pts[,1:3])
plotPoints3D(pts[pts$nd,1:3], argsPlot3d = list(col = "red", size = 10))
plotCones3D(pts[pts$nd,1:3], argsPolygon3d = list(alpha = 1))
finalize3D()


## Between planes
range <- matrix(c(1,10000, 1,10000), ncol = 2, byrow = TRUE)
pts <- genNDSet(2, 50, range = range, planes = TRUE, classify = TRUE)
head(pts)
Rfast::colMinsMaxs(as.matrix(pts[, 1:2]))
plot(pts[, 1:2])

range <- matrix(c(1,100, 50,100, 10, 50), ncol = 2, byrow = TRUE)
center <- rowMeans(range)
planeU <- c(rep(1, 3), -1.2*sum(rowMeans(range)))
planeL <- c(rep(1, 3), -0.8*sum(rowMeans(range)))
pts <- genNDSet(3, 50, range = range, planes = TRUE, keepDom = TRUE, classify = TRUE,
   argsPlanes = list(center = center, planeU = planeU, planeL = planeL))
head(pts)
Rfast::colMinsMaxs(as.matrix(pts[, 1:3]))
ini3D(FALSE, argsPlot3d = list(xlim = c(min(pts[,1])-2,max(pts[,1])+10),
  ylim = c(min(pts[,2])-2,max(pts[,2])+10),
  zlim = c(min(pts[,3])-2,max(pts[,3])+10),
  box = TRUE, axes = TRUE))
plotPoints3D(pts[,1:3])
plotPoints3D(pts[pts$nd,1:3], argsPlot3d = list(col = "red", size = 10))
rgl::planes3d(planeL[1], planeL[2], planeL[3], planeL[4], alpha = 0.5)
rgl::planes3d(planeU[1], planeU[2], planeU[3], planeU[4], alpha = 0.5)
finalize3D()


## On a sphere
ini3D()
range <- c(1,100)
cent <- rep(range[1] + (range[2]-range[1])/2, 3)
pts <- genNDSet(3, 20, range = range, sphere = TRUE, keepDom = TRUE,
       argsSphere = list(center = cent))
rgl::spheres3d(cent, radius=49.5, color = "grey100", alpha=0.1)
plotPoints3D(pts)
plotPoints3D(pts[pts$nd,], argsPlot3d = list(col = "red", size = 10))
rgl::planes3d(cent[1],cent[2],cent[3],-sum(cent^2), alpha = 0.5, col = "red")
finalize3D()

ini3D()
cent <- c(100,100,100)
r <- 75
planeC <- c(cent+r/3)
planeC <- c(planeC, -sum(planeC^2))
pts <- genNDSet(3, 20, keepDom = TRUE,
  argsSphere = list(center = cent, radius = r, below = FALSE, plane = planeC, factor = 6))
rgl::spheres3d(cent, radius=r, color = "grey100", alpha=0.1)
plotPoints3D(pts)
plotPoints3D(pts[pts$nd,], argsPlot3d = list(col = "red", size = 10))
rgl::planes3d(planeC[1],planeC[2],planeC[3],planeC[4], alpha = 0.5, col = "red")
finalize3D()
}
}
