% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotHull2D}
\alias{plotHull2D}
\title{Plot the convex hull of a set of points in 2D.}
\usage{
plotHull2D(
  pts,
  drawPoints = FALSE,
  drawLines = TRUE,
  drawPolygons = TRUE,
  addText = FALSE,
  addRays = FALSE,
  direction = 1,
  drawPlot = TRUE,
  drawBBoxHull = FALSE,
  m = apply(pts, 2, min) - 5,
  M = apply(pts, 2, max) + 5,
  ...
)
}
\arguments{
\item{pts}{A matrix with a point in each row.}

\item{drawPoints}{Draw the points.}

\item{drawLines}{Draw lines of the facets.}

\item{drawPolygons}{Fill the hull.}

\item{addText}{Add text to the points. Currently \code{coord} (coordinates), \code{rownames} (rownames)
and \code{both} supported or a vector with text.}

\item{addRays}{Add the ray defined by \code{direction}.}

\item{direction}{Ray direction. If i'th entry is positive, consider the i'th column of \code{pts}
plus a value greater than on equal zero (minimize objective $i$). If negative, consider the
i'th column of \code{pts} minus a value greater than on equal zero (maximize objective $i$).}

\item{drawPlot}{Draw the ggplot. Set to FALSE if you want to combine hulls in a single plot.}

\item{drawBBoxHull}{If addRays then draw the hull areas hitting the bounding box also.}

\item{m}{Minimum values of the bounding box.}

\item{M}{Maximum values of the bounding box.}

\item{...}{Further arguments passed on the the ggplot plotting functions. This must be done as
lists. Currently the following arguments are supported:
\itemize{
\item \code{argsGeom_point}: A list of arguments for \code{\link[ggplot2:geom_point]{ggplot2::geom_point}}.
\item \code{argsGeom_path}: A list of arguments for \code{\link[ggplot2:geom_path]{ggplot2::geom_path}}.
\item \code{argsGeom_polygon}: A list of arguments for \code{\link[ggplot2:geom_polygon]{ggplot2::geom_polygon}}.
\item \code{argsGeom_label}: A list of arguments for \code{\link[ggplot2:geom_text]{ggplot2::geom_label}}.
}}
}
\value{
The ggplot object if \code{drawPlot = TRUE}; otherwise, a list of ggplot components.
}
\description{
Plot the convex hull of a set of points in 2D.
}
\examples{
library(ggplot2)
pts<-matrix(c(1,1), ncol = 2, byrow = TRUE)
plotHull2D(pts)
pts1<-matrix(c(2,2, 3,3), ncol = 2, byrow = TRUE)
plotHull2D(pts1, drawPoints = TRUE)
plotHull2D(pts1, drawPoints = TRUE, addRays = TRUE, addText = "coord")
plotHull2D(pts1, drawPoints = TRUE, addRays = TRUE, addText = "coord", drawBBoxHull = TRUE)
plotHull2D(pts1, drawPoints = TRUE, addRays = TRUE, direction = -1, addText = "coord")
pts2<-matrix(c(1,1, 2,2, 0,1), ncol = 2, byrow = TRUE)
plotHull2D(pts2, drawPoints = TRUE, addText = "coord")
plotHull2D(pts2, drawPoints = TRUE, addRays = TRUE, addText = "coord")
plotHull2D(pts2, drawPoints = TRUE, addRays = TRUE, direction = -1, addText = "coord")
## Combine hulls
ggplot() +
  plotHull2D(pts2, drawPoints = TRUE, addText = "coord", drawPlot = FALSE) +
  plotHull2D(pts1, drawPoints = TRUE, drawPlot = FALSE) +
  gMOIPTheme() +
  xlab(expression(x[1])) +
  ylab(expression(x[2]))

# Plotting an LP
A <- matrix(c(-3,2,2,4,9,10), ncol = 2, byrow = TRUE)
b <- c(3,27,90)
obj <- c(7.75, 10)
pts3 <- cornerPoints(A, b)
plotHull2D(pts3, drawPoints = TRUE, addText = "coord", argsGeom_polygon = list(fill = "red"))
}
