% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cornerPointsCont}
\alias{cornerPointsCont}
\title{Calculate the corner points for the polytope Ax<=b assuming all variables are
continuous.}
\usage{
cornerPointsCont(A, b, nonneg = rep(TRUE, ncol(A)))
}
\arguments{
\item{A}{Constraint matrix.}

\item{b}{Right hand side.}

\item{nonneg}{A boolean vector of same length as number of variables. If
entry k is TRUE then variable k must be non-negative.}
}
\value{
A data frame with a corner point in each row.
}
\description{
Calculate the corner points for the polytope Ax<=b assuming all variables are
continuous.
}
\author{
Lars Relund \email{lars@relund.dk}
}
