/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.af.commons.images.GraphDrawHelper;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.ReproducableLog;
import org.af.gMCP.gui.dialogs.VariableDialog;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.GraphMCP;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.NetListPopUpMenu;
import org.af.gMCP.gui.graph.NetListSelectionPopUpMenu;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.UpdateEdge;
import org.af.gMCP.gui.graph.UpdateNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetList
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final Log logger = LogFactory.getLog(NetList.class);
    GraphView control;
    public GraphMCP graph;
    int[] dragN = new int[0];
    int[] dragE = new int[0];
    boolean unAnchor = false;
    protected Vector<Edge> edges = new Vector();
    protected Vector<Node> nodes = new Vector();
    Node firstVertex;
    boolean firstVertexSelected = false;
    public String initialGraph = ".InitialGraph" + new Date().getTime();
    public String resetGraph = ".ResetGraph" + new Date().getTime();
    public String tmpGraph = ".tmpGraph" + new Date().getTime();
    boolean newEdge = false;
    boolean newVertex = false;
    JLabel statusBar;
    public boolean testingStarted = false;
    double zoom = 1.0;
    static DecimalFormat format = new DecimalFormat("#.####");
    public static Color[] layerColors = new Color[]{Color.BLACK, Color.BLUE, Color.RED, Color.YELLOW, Color.GREEN};
    public boolean updateGUI = true;
    Point arrowHeadPoint = null;
    protected int[][] offsetE;
    protected int[][] offsetN;
    protected int[] startingPoint = null;
    protected int[] endPoint = null;
    Double expRejections = null;
    Double powAtlst1 = null;
    Double rejectAll = null;
    Double[] userDefined = null;
    String[] userFunctions = null;

    public NetList(JLabel statusBar, GraphView graphview) {
        this.statusBar = statusBar;
        this.control = graphview;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        Font f = statusBar.getFont();
        statusBar.setFont(f.deriveFont(f.getStyle() ^ 1));
    }

    public void acceptNode(Node node) {
        this.control.getPView().savePValues();
        this.saveGraph(".tmpGraph", false);
        RControl.getR().eval(".tmpGraph <- substituteEps(.tmpGraph, eps=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ")");
        ReproducableLog.logR(RControl.getR().eval("gMCP:::dputGraph(.tmpGraph, \".tmpGraph\")").asRChar().getData()[0]);
        RControl.evalAndLog(".tmpGraph <- rejectNode(.tmpGraph, \"" + node.getName() + "\")");
        this.reset();
        new GraphMCP(".tmpGraph", this);
        this.control.getPView().restorePValues();
    }

    public void addDefaultNode(int x, int y) {
        int i = this.nodes.size() + 1;
        String name = "H" + i;
        while (this.whichNode(name) != -1) {
            name = "H" + ++i;
        }
        this.addNode(new Node(name, x, y, new double[]{0.0}, this));
    }

    public void setEdge(Edge e) {
        Edge old = null;
        for (Edge e2 : this.edges) {
            if (e2.from == e.from && e2.to == e.to && e2.layer == e.layer) {
                old = e2;
            }
            if (e2.from != e.to || e2.to != e.from || e2.layer != e.layer) continue;
            e.curve = true;
            e2.curve = true;
        }
        if (old != null) {
            this.edges.remove(old);
        }
        this.edges.add(e);
        this.control.getDataFramePanel().setValueAt(e.getEdgeWeight(), this.getNodes().indexOf(e.from), this.getNodes().indexOf(e.to), e.layer);
        this.graphHasChanged();
    }

    public void setEdge(Node from, Node to, int layer) {
        this.setEdge(from, to, 1.0, layer);
    }

    public void setEdge(Node from, Node to, Double w, int layer) {
        this.setEdge(from, to, new EdgeWeight(w), layer);
    }

    public void setEdge(Node from, Node to, EdgeWeight w, int layer) {
        Integer x = null;
        Integer y = null;
        boolean curve = false;
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            if (this.edges.get((int)i).from != from || this.edges.get((int)i).to != to || this.edges.get((int)i).layer != layer) continue;
            x = this.edges.get(i).getK1();
            y = this.edges.get(i).getK2();
            this.removeEdge(this.edges.get(i));
        }
        for (Edge e : this.edges) {
            if (e.from != to || e.to != from || e.layer != layer) continue;
            e.curve = true;
            curve = true;
        }
        if (!w.toString().equals("0")) {
            if (x != null) {
                this.edges.add(new Edge(from, to, w, this, (int)x, (int)y, layer));
            } else {
                this.edges.add(new Edge(from, to, w, this, curve, layer));
            }
            this.edges.lastElement().curve = curve;
        }
        this.control.getDataFramePanel().setValueAt(w, this.getNodes().indexOf(from), this.getNodes().indexOf(to), layer);
        this.graphHasChanged();
    }

    public void addNode(Node node) {
        this.control.enableButtons(true);
        this.nodes.add(node);
        this.control.getPView().addPPanel(node);
        this.control.getDataFramePanel().addRowCol(node.getName());
        this.calculateSize();
        this.graphHasChanged();
    }

    public void graphHasChanged() {
        this.expRejections = null;
        this.powAtlst1 = null;
        this.rejectAll = null;
        this.userDefined = null;
        this.control.setResultUpToDate(false);
        this.control.isGraphSaved = false;
        if (!this.updateGUI) {
            return;
        }
        String analysis = null;
        Set<String> variables = this.getAllVariables();
        variables.remove("\u03b5");
        if (variables.size() == 0) {
            try {
                String graphName = ".tmpGraph" + new Date().getTime();
                this.saveGraph(graphName, false);
                analysis = RControl.getR().eval("graphAnalysis(" + graphName + ", file=tempfile())").asRChar().getData()[0];
            }
            catch (Exception exception) {}
        } else {
            analysis = "Graphs with variables are not yet supported for analysis.";
        }
        this.control.getDView().setAnalysis(analysis);
    }

    public int[] calculateSize() {
        int i;
        int maxX = 0;
        int maxY = 0;
        for (i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getX() > maxX) {
                maxX = this.nodes.get(i).getX();
            }
            if (this.nodes.get(i).getY() <= maxY) continue;
            maxY = this.nodes.get(i).getY();
        }
        for (i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i).getK1() > maxX) {
                maxX = this.edges.get(i).getK1();
            }
            if (this.edges.get(i).getK2() <= maxY) continue;
            maxY = this.edges.get(i).getK2();
        }
        this.setPreferredSize(new Dimension((int)((double)(maxX + 2 * Node.getRadius() + 30) * this.getZoom()), (int)((double)(maxY + 2 * Node.getRadius() + 30) * this.getZoom())));
        if (this.updateGUI) {
            this.revalidate();
            this.repaint();
        }
        return new int[]{maxX, maxY};
    }

    public Edge findEdge(Node von, Node nach, int layer) {
        for (Edge e : this.edges) {
            if (von != e.from || nach != e.to || e.layer != layer) continue;
            return e;
        }
        return null;
    }

    public Vector<Edge> getEdges() {
        return this.edges;
    }

    public BufferedImage getImage(Double zoom) {
        if (zoom == null) {
            zoom = this.getZoom();
        }
        double oldZoom = this.getZoom();
        this.setZoom(zoom);
        long maxX = 0L;
        long maxY = 0L;
        for (Node node : this.nodes) {
            if ((long)node.getX() > maxX) {
                maxX = node.getX();
            }
            if ((long)node.getY() <= maxY) continue;
            maxY = node.getY();
        }
        for (Edge edge : this.edges) {
            if ((long)edge.getK1() > maxX) {
                maxX = edge.getK1();
            }
            if ((long)edge.getK2() <= maxY) continue;
            maxY = edge.getK2();
        }
        BufferedImage img = new BufferedImage((int)((double)(maxX + (long)(2 * Node.getRadius()) + 400L) * this.getZoom()), (int)((double)(maxY + (long)(2 * Node.getRadius()) + 400L) * this.getZoom()), 2);
        Graphics2D g = img.createGraphics();
        if (!Configuration.getInstance().getGeneralConfig().exportTransparent()) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
        }
        g.setStroke(new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.nodes) {
            node.paintYou(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdge(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdgeLabel(g);
        }
        img = this.cutImage(img, 5);
        this.setZoom(oldZoom);
        return img;
    }

    private BufferedImage cutImage(BufferedImage img, int offset) {
        int minX = img.getWidth();
        int minY = img.getHeight();
        int maxX = 0;
        int maxY = 0;
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                if (img.getRGB(x, y) == 0 || img.getRGB(x, y) == -1) continue;
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        return img.getSubimage(Math.max(0, minX - offset), Math.max(0, minY - offset), Math.min(maxX - minX + 2 * offset, img.getWidth()), Math.min(maxY - minY + 2 * offset, img.getHeight()));
    }

    public Vector<Node> getNodes() {
        return this.nodes;
    }

    public String getLaTeX() {
        this.saveGraph(this.tmpGraph, false);
        return RControl.getR().eval("graph2latex(" + this.tmpGraph + ")").asRChar().getData()[0];
    }

    public double getZoom() {
        return this.zoom;
    }

    public boolean isTesting() {
        return this.testingStarted;
    }

    public GraphMCP loadGraph() {
        this.control.stopTesting();
        this.reset();
        this.updateGUI = false;
        this.graph = new GraphMCP(this.initialGraph, this);
        this.control.getPView().restorePValues();
        if (this.graph.entangledWeights != null) {
            this.control.getPView().setEntangledWeights(this.graph.entangledWeights);
        }
        this.updateGUI = true;
        this.graphHasChanged();
        this.revalidate();
        this.repaint();
        if (this.graph.getDescription() != null) {
            this.control.getDView().setDescription(this.graph.getDescription());
        } else {
            this.control.getDView().setDescription("");
        }
        return this.graph;
    }

    public void loadGraph(String string) {
        boolean matrix = RControl.getR().eval("is.matrix(" + string + ")").asRLogical().getData()[0];
        RControl.getR().eval(this.initialGraph + " <- placeNodes(" + (matrix ? "matrix2graph(" : "(") + string + "))");
        this.graph = this.loadGraph();
        if (this.graph.getDescription() != null) {
            this.control.getDView().setDescription(this.graph.getDescription());
        } else {
            this.control.getDView().setDescription("");
        }
        if (this.graph.pvalues != null && this.graph.pvalues.length > 1) {
            this.control.getPView().setPValues(this.graph.pvalues);
        }
    }

    private void showPopUp(MouseEvent e, Node node, Edge edge) {
        NetListPopUpMenu menu = new NetListPopUpMenu(this, node, edge);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.firstVertexSelected) {
            this.arrowHeadPoint = e.getPoint();
            this.repaint();
            return;
        }
        if (this.dragN.length == 0 && this.dragE.length == 0) {
            this.endPoint = new int[]{e.getX(), e.getY()};
            this.repaint();
            return;
        }
        for (int i : this.dragN) {
            if (!this.unAnchor && Configuration.getInstance().getGeneralConfig().getUnAnchor()) {
                for (Edge edge : this.getEdges()) {
                    if (edge.from != this.nodes.get(i) && edge.to != this.nodes.get(i)) continue;
                    edge.fixed = false;
                }
                this.unAnchor = true;
            }
            this.nodes.get(i).setX((int)((double)(e.getX() + this.offsetN[i][0]) / this.getZoom()));
            this.nodes.get(i).setY((int)((double)(e.getY() + this.offsetN[i][1]) / this.getZoom()));
            this.placeUnfixedNodes(this.nodes.get(i));
        }
        for (int i : this.dragE) {
            this.edges.get(i).setK1((int)((double)(e.getX() + this.offsetE[i][0]) / this.getZoom()));
            this.edges.get(i).setK2((int)((double)(e.getY() + this.offsetE[i][1]) / this.getZoom()));
        }
        this.calculateSize();
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.firstVertexSelected) {
            this.arrowHeadPoint = e.getPoint();
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popUp(e);
        }
        if (e.getButton() == 2) {
            this.newVertex = false;
            this.control.buttonNewNode.setSelected(false);
            return;
        }
        if (this.newVertex && this.vertexSelected(e.getX(), e.getY()) == null) {
            this.addDefaultNode((int)((double)e.getX() / this.getZoom()) - Node.r, (int)((double)e.getY() / this.getZoom()) - Node.r);
            this.statusBar.setText("Place new nodes and edges or start the test procedure");
            this.repaint();
            return;
        }
        if (this.newEdge) {
            if (!this.firstVertexSelected) {
                this.firstVertex = this.vertexSelected(e.getX(), e.getY());
                if (this.firstVertex == null) {
                    return;
                }
                this.firstVertexSelected = true;
                this.statusBar.setText("Select a second node to which the edge should lead.");
            } else {
                Node secondVertex = this.vertexSelected(e.getX(), e.getY());
                if (secondVertex == null || secondVertex == this.firstVertex) {
                    return;
                }
                this.setEdge(this.firstVertex, secondVertex, this.askForLayer());
                this.newEdge = false;
                this.arrowHeadPoint = null;
                this.firstVertexSelected = false;
                this.statusBar.setText("Place new nodes and edges or start the test procedure");
            }
            this.repaint();
            return;
        }
        if (this.dragN.length != 0 || this.dragE.length != 0) {
            this.offsetN = new int[this.nodes.size()][2];
            this.offsetE = new int[this.edges.size()][2];
            for (int i : this.dragN) {
                this.offsetN[i] = this.nodes.get(i).offset(e.getX(), e.getY());
            }
            for (int i : this.dragE) {
                this.offsetE[i] = this.edges.get(i).offset(e.getX(), e.getY());
            }
        } else {
            int i;
            for (i = 0; i < this.nodes.size(); ++i) {
                if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
                this.dragN = new int[]{i};
                this.offsetN = new int[this.nodes.size()][2];
                this.offsetN[i] = this.nodes.get(i).offset(e.getX(), e.getY());
            }
            for (i = this.edges.size() - 1; i >= 0; --i) {
                if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
                this.dragN = new int[0];
                this.dragE = new int[]{i};
                this.offsetE = new int[this.edges.size()][2];
                this.offsetE[i] = this.edges.get(i).offset(e.getX(), e.getY());
            }
        }
        if (e.getClickCount() == 2 && !this.testingStarted) {
            int i;
            for (i = this.edges.size() - 1; i >= 0; --i) {
                if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateEdge(this.edges.get(i), this, this.control);
                this.mouseReleased(null);
                this.repaint();
                return;
            }
            for (i = this.nodes.size() - 1; i >= 0; --i) {
                if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateNode(this.nodes.get(i), this.control);
                this.mouseReleased(null);
                this.repaint();
                return;
            }
        }
        this.startingPoint = new int[]{e.getX(), e.getY()};
        this.repaint();
    }

    private int askForLayer() {
        int layer = 0;
        if (this.control.getNumberOfLayers() > 1) {
            layer = this.control.getDataFramePanel().getSelectedIndex();
        }
        return layer;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragN = new int[0];
        this.dragE = new int[0];
        if (e != null) {
            if (this.endPoint != null && this.startingPoint != null && Configuration.getInstance().getGeneralConfig().experimentalFeatures()) {
                Vector<Node> nodes = new Vector<Node>();
                Vector<Edge> edges = new Vector<Edge>();
                for (Edge edge : this.edges) {
                    if (!edge.containsYou(this.startingPoint, this.endPoint)) continue;
                    edges.add(edge);
                }
                for (Node node : this.nodes) {
                    if (!node.containsYou(this.startingPoint, this.endPoint)) continue;
                    nodes.add(node);
                }
                NetListSelectionPopUpMenu menu = new NetListSelectionPopUpMenu(this, nodes, edges);
                menu.show(e.getComponent(), e.getX() - 20, e.getY() - 20);
            } else if (e.isPopupTrigger()) {
                this.popUp(e);
            }
        }
        for (int i : this.dragE) {
            this.edges.get(i).setFixed(true);
        }
        this.unAnchor = false;
        this.endPoint = null;
        if (e != null && this.newEdge && this.firstVertexSelected) {
            Node secondVertex = this.vertexSelected(e.getX(), e.getY());
            if (secondVertex == null || secondVertex == this.firstVertex) {
                return;
            }
            this.setEdge(this.firstVertex, secondVertex, this.askForLayer());
            this.newEdge = false;
            this.arrowHeadPoint = null;
            this.firstVertexSelected = false;
            this.statusBar.setText("Place new nodes and edges or start the test procedure");
            this.repaint();
            return;
        }
    }

    public void popUp(MouseEvent e) {
        int i;
        for (i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
            this.showPopUp(e, this.nodes.get(i), null);
        }
        for (i = this.edges.size() - 1; i >= 0; --i) {
            if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
            this.showPopUp(e, null, this.edges.get(i));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.updateGUI) {
            return;
        }
        super.paintComponent(g);
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        g.setColor(Color.LIGHT_GRAY);
        if (grid > 1) {
            int x = (int)((double)Node.r * this.getZoom());
            while (x < this.getWidth()) {
                g.drawLine(x, 0, x, this.getHeight());
                x = (int)((double)x + (double)grid * this.getZoom());
            }
            x = (int)((double)Node.r * this.getZoom());
            while (x > 0) {
                g.drawLine(x, 0, x, this.getHeight());
                x = (int)((double)x - (double)grid * this.getZoom());
            }
            int y = (int)((double)Node.r * this.getZoom());
            while (y < this.getHeight()) {
                g.drawLine(0, y, this.getWidth(), y);
                y = (int)((double)y + (double)grid * this.getZoom());
            }
            y = (int)((double)Node.r * this.getZoom());
            while (y > 0) {
                g.drawLine(0, y, this.getWidth(), y);
                y = (int)((double)y - (double)grid * this.getZoom());
            }
        }
        BasicStroke stroke = new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth());
        ((Graphics2D)g).setStroke(stroke);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.nodes) {
            node.paintYou(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdge(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdgeLabel(g);
        }
        if (this.endPoint != null && this.startingPoint != null && Configuration.getInstance().getGeneralConfig().experimentalFeatures()) {
            int x = Math.min(this.startingPoint[0], this.endPoint[0]);
            int y = Math.min(this.startingPoint[1], this.endPoint[1]);
            int width = Math.abs(this.startingPoint[0] - this.endPoint[0]);
            int height = Math.abs(this.startingPoint[1] - this.endPoint[1]);
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            ((Graphics2D)g).setPaint(new Color(0, 0, 255, 30));
            ((Graphics2D)g).fillRect(x, y, width, height);
            ((Graphics2D)g).setPaint(new Color(0, 0, 255));
            ((Graphics2D)g).drawRect(x, y, width, height);
        }
        if (this.firstVertexSelected && this.firstVertex != null && this.arrowHeadPoint != null) {
            double c2;
            double a1 = this.firstVertex.getX() + Node.getRadius();
            double a2 = this.firstVertex.getY() + Node.getRadius();
            double c1 = this.arrowHeadPoint.getX() / this.getZoom();
            if (!this.firstVertex.inYou((int)c1, (int)(c2 = this.arrowHeadPoint.getY() / this.getZoom()))) {
                double dx = a1 - c1;
                double dy = a2 - c2;
                double d = Math.sqrt(dx * dx + dy * dy);
                g.setColor(Color.DARK_GRAY);
                GraphDrawHelper.malVollenPfeil((Graphics)g, (int)((int)((a1 -= (double)Node.getRadius() * dx / d) * this.getZoom())), (int)((int)((a2 -= (double)Node.getRadius() * dy / d) * this.getZoom())), (int)((int)(c1 * this.getZoom())), (int)((int)(c2 * this.getZoom())), (int)((int)(8.0 * this.getZoom())), (int)35);
                g.setColor(Color.BLACK);
            }
        }
        if (this.expRejections != null && this.powAtlst1 != null && this.rejectAll != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setFont(new Font("Arial", 1, (int)(12.0 * this.getZoom())));
            String s = "Expected number of rejections: " + format.format(this.expRejections);
            g2d.drawString(s, (float)(10.0 * this.getZoom()), (float)(20.0 * this.getZoom()));
            s = "Prob. to reject at least one hyp.: " + format.format(this.powAtlst1);
            g2d.drawString(s, (float)(10.0 * this.getZoom()), (float)(50.0 * this.getZoom()));
            s = "Prob. to reject all hypotheses: " + format.format(this.rejectAll);
            g2d.drawString(s, (float)(10.0 * this.getZoom()), (float)(80.0 * this.getZoom()));
            if (this.userDefined != null) {
                for (int i = 0; i < this.userDefined.length; ++i) {
                    s = "User defined Power (" + this.userFunctions[i] + "): " + format.format(this.userDefined[i]);
                    g2d.drawString(s, (float)(10.0 * this.getZoom()), (float)((double)(20 + 30 * (3 + i)) * this.getZoom()));
                }
            }
        }
    }

    public void refresh() {
        this.calculateSize();
        this.revalidate();
        this.repaint();
    }

    public void removeEdge(Edge edge) {
        logger.info((Object)("Removing " + edge));
        for (Edge e : this.edges) {
            if (e.from != edge.to || e.to != edge.from || e.layer != edge.layer) continue;
            e.curve = false;
        }
        this.edges.remove(edge);
        this.dragE = new int[0];
        this.control.getDataFramePanel().setValueAt(new EdgeWeight(0.0), this.getNodes().indexOf(edge.from), this.getNodes().indexOf(edge.to), edge.layer);
        this.graphHasChanged();
    }

    public void removeNode(Node node) {
        logger.info((Object)("Removing " + node));
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            Edge e = this.edges.get(i);
            if (e.from != node && e.to != node) continue;
            this.edges.remove(e);
        }
        this.control.getDataFramePanel().delRowCol(this.getNodes().indexOf(node));
        this.nodes.remove(node);
        this.control.getPView().removePPanel(node);
        if (this.nodes.size() == 0) {
            this.control.enableButtons(false);
        }
        this.repaint();
        this.graphHasChanged();
    }

    public void reset() {
        logger.info((Object)"Reset.");
        this.edges.removeAllElements();
        for (int i = this.getNodes().size() - 1; i >= 0; --i) {
            this.removeNode(this.getNodes().get(i));
        }
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
        this.firstVertexSelected = false;
        this.newVertex = false;
        this.newEdge = false;
        this.zoom = 1.0;
        this.control.getDataFramePanel().reset();
        this.control.getDView().setDescription("Enter a description for the graph.");
        this.graphHasChanged();
        this.control.isGraphSaved = true;
    }

    public void saveGraph() {
        this.saveGraph(this.initialGraph, false);
        this.control.getPView().savePValues();
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (Edge e : this.edges) {
            variables.addAll(e.getVariable());
        }
        return variables;
    }

    public String saveGraphWithoutVariables(String graphName, boolean verbose) {
        Set<String> variables = this.getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        Hashtable<String, Double> ht = new Hashtable<String, Double>();
        if (!(variables.isEmpty() || variables.size() == 1 && variables.contains("\u03b5"))) {
            VariableDialog vd = new VariableDialog(this.control.parent, variables);
            ht = vd.getHT();
        } else if (variables.size() == 1 && variables.contains("\u03b5")) {
            ht.put("\u03b5", Configuration.getInstance().getGeneralConfig().getEpsilon());
        }
        graphName = RControl.getR().eval("make.names(\"" + graphName + "\")").asRChar().getData()[0];
        this.saveGraph(graphName, verbose, null);
        RControl.getR().eval(graphName + "<- gMCP:::replaceVariables(" + graphName + ", variables=" + this.getRVariableList(ht) + ", ask=FALSE)");
        this.loadGraph(graphName);
        return this.saveGraph(graphName, verbose, ht);
    }

    public String saveGraph(String graphName, boolean verbose) {
        return this.saveGraph(graphName, verbose, new Hashtable<String, Double>());
    }

    public String getRVariableList(Hashtable<String, Double> ht) {
        String list = "list(";
        Enumeration<String> keys = ht.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            list = list + "\"" + EdgeWeight.UTF2LaTeX(key.charAt(0)) + "\"=" + ht.get(key) + ",";
        }
        list = list + "\"epsilon\"=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ",";
        return list.substring(0, list.length() > 5 ? list.length() - 1 : list.length()) + ")";
    }

    public String saveGraph(String graphNameOld, boolean verbose, Hashtable<String, Double> ht) {
        if (this.nodes.size() == 0) {
            throw new RuntimeException("Cannot save empty graph.");
        }
        String graphName = RControl.getR().eval("make.names(\"" + graphNameOld + "\")").asRChar().getData()[0];
        if (this.control.getNumberOfLayers() == 1) {
            this.saveSingleLayerGraph(graphName, verbose, ht, 0);
        } else {
            String graphs = "";
            String weights = "";
            for (int i = 0; i < this.control.getNumberOfLayers(); ++i) {
                this.saveSingleLayerGraph(this.tmpGraph + "_layer_" + i, verbose, ht, i);
                graphs = graphs + this.tmpGraph + "_layer_" + i;
                weights = weights + this.control.getPView().entangledWeights.get(i).getText();
                if (i == this.control.getNumberOfLayers() - 1) continue;
                graphs = graphs + ", ";
                weights = weights + ", ";
            }
            RControl.getR().evalVoid(graphName + " <- new(\"entangledMCP\", subgraphs=list(" + graphs + "), weights=c(" + weights + "))");
        }
        RControl.getR().evalVoid("attr(" + graphName + ", \"description\") <- \"" + this.control.getDView().getDescription() + "\"");
        RControl.getR().evalVoid("attr(" + graphName + ", \"pvalues\") <- " + this.control.getPView().getPValuesString());
        if (verbose && !graphName.equals(graphNameOld)) {
            JOptionPane.showMessageDialog(this, "The graph as been exported to R under ther variable name:\n\n" + graphName, "Saved as \"" + graphName + "\"", 1);
        }
        return graphName;
    }

    private void saveSingleLayerGraph(String graphName, boolean verbose, Hashtable<String, Double> ht, int layer) {
        String alpha = "";
        String nodeStr = "";
        String x = "";
        String y = "";
        for (Node n : this.nodes) {
            alpha = alpha + n.getWeight().get(layer) + ",";
            nodeStr = nodeStr + "\"" + n.getRName() + "\",";
            x = x + n.getX() + ",";
            y = y + n.getY() + ",";
        }
        alpha = alpha.substring(0, alpha.length() - 1);
        nodeStr = nodeStr.substring(0, nodeStr.length() - 1);
        x = x.substring(0, x.length() - 1);
        y = y.substring(0, y.length() - 1);
        RControl.getR().evalVoid(".gsrmtVar <- list()");
        RControl.getR().evalVoid(".gsrmtVar$alpha <- c(" + alpha + ")");
        RControl.getR().evalVoid(".gsrmtVar$hnodes <- c(" + nodeStr + ")");
        RControl.getR().evalVoid(".gsrmtVar$m <- matrix(0, nrow=" + this.nodes.size() + ", ncol=" + this.nodes.size() + ")");
        RControl.getR().evalVoid("rownames(.gsrmtVar$m) <- colnames(.gsrmtVar$m) <- .gsrmtVar$hnodes");
        for (Edge e : this.edges) {
            if (e.layer != layer) continue;
            RControl.getR().evalVoid(".gsrmtVar$m[\"" + e.from.getRName() + "\",\"" + e.to.getRName() + "\"] <- \"" + e.getPreciseWeightStr().replaceAll("\\\\", "\\\\\\\\") + "\"");
        }
        RControl.getR().evalVoid(".gsrmtVar$m <- gMCP:::parse2numeric(.gsrmtVar$m)");
        RControl.getR().evalVoid(graphName + " <- new(\"graphMCP\", m=.gsrmtVar$m, weights=.gsrmtVar$alpha)");
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            Node n;
            n = this.nodes.get(i);
            if (!n.isRejected()) continue;
            RControl.getR().evalVoid("nodeAttr(" + graphName + ", \"" + n.getName() + "\", \"rejected\") <- TRUE");
        }
        RControl.getR().evalVoid(graphName + "@nodeAttr$X <- c(" + x + ")");
        RControl.getR().evalVoid(graphName + "@nodeAttr$Y <- c(" + y + ")");
        for (Edge e : this.edges) {
            if (e.layer != layer) continue;
            RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getRName() + "\", \"" + e.to.getRName() + "\", \"labelX\") <- " + (e.k1 - Node.getRadius()));
            RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getRName() + "\", \"" + e.to.getRName() + "\", \"labelY\") <- " + (e.k2 - Node.getRadius()));
            if (Double.valueOf(e.getW(ht)).isNaN()) {
                RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getRName() + "\", \"" + e.to.getRName() + "\", \"variableWeight\") <- \"" + e.getWS().replaceAll("\\\\", "\\\\\\\\") + "\"");
            }
            if (e.getW(ht) != 0.0) continue;
            RControl.getR().evalVoid(graphName + "@m[\"" + e.from.getRName() + "\", \"" + e.to.getRName() + "\"] <- 0");
        }
    }

    public void setEdges(Vector<Edge> edges) {
        this.edges = edges;
        this.graphHasChanged();
    }

    public void setKnoten(Vector<Node> knoten) {
        this.nodes = knoten;
        this.graphHasChanged();
    }

    public void setZoom(double p) {
        this.zoom = p;
    }

    public void startTesting() {
        this.testingStarted = true;
        this.statusBar.setText("Reject nodes or reset to the initial graph for modifications.");
    }

    public void stopTesting() {
        this.testingStarted = false;
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
    }

    public Node vertexSelected(int x, int y) {
        for (Node n : this.nodes) {
            if (!n.inYou(x, y)) continue;
            return n;
        }
        return null;
    }

    public int whichNode(String name) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public String getGraphName() {
        this.saveGraph(".tmpGraph", false);
        return ".tmpGraph";
    }

    public void setPower(double[] localPower, Double expRejections, Double powAtlst1, Double rejectAll, Double[] userDefined, String[] functions) {
        for (int i = 0; i < localPower.length; ++i) {
            this.nodes.get(i).setLocalPower(localPower[i]);
        }
        this.expRejections = expRejections;
        this.powAtlst1 = powAtlst1;
        this.rejectAll = rejectAll;
        this.userDefined = userDefined;
        this.userFunctions = functions;
        this.repaint();
    }

    private void placeUnfixedNodes(Node node) {
        for (Edge e : this.edges) {
            if (e.from != node && e.to != node || e.isFixed()) continue;
            e.move();
        }
    }

    public void removeLayer(int layer) {
        for (int i = this.edges.size(); i > 0; --i) {
            if (this.edges.get((int)(i - 1)).layer != layer) continue;
            this.edges.remove(i - 1);
        }
        for (Node n : this.nodes) {
            n.removeLayer(layer);
        }
        this.refresh();
    }

    public void addEntangledLayer() {
        for (Node n : this.nodes) {
            n.addLayer();
        }
        this.refresh();
    }
}

