% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_canvas_resize}
\alias{g6_canvas_resize}
\title{Resize the canvas of a g6 graph via proxy}
\usage{
g6_canvas_resize(graph, width, height)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{width}{Numeric value specifying the new width of the canvas in pixels.}

\item{height}{Numeric value specifying the new height of the canvas in pixels.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function changes the size of the canvas of an existing g6 graph instance
using a proxy object. This allows updating the graph dimensions without completely
re-rendering it.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

See \url{https://g6.antv.antgroup.com/en/api/canvas#graphsetsizewidth-height} for more details.
}
\seealso{
\code{\link{g6_proxy}}
}
