% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{get_all_expressions}
\alias{get_all_expressions}
\title{Get all parsed expressions from an R file}
\usage{
get_all_expressions(file_path)
}
\arguments{
\item{file_path}{Character string. Path to an R file to parse.}
}
\value{
A list of parsed expressions, or \code{NULL} if parsing fails.
}
\description{
Reads an R source file and parses it into a list of expressions. This is a
utility function primarily used internally by
\code{\link{analyze_internal_dependencies_multi}}.
}
\examples{
# Create a temporary R file
temp_file <- tempfile(fileext = ".R")
writeLines(c(
  "my_function <- function(x) { x + 1 }",
  "another_function <- function(y) { y * 2 }"
), temp_file)

# Parse the file
exprs <- get_all_expressions(temp_file)
if (!is.null(exprs)) {
  print(length(exprs))
}

# Clean up
unlink(temp_file)
}
