% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarity_dimensions.R
\name{uniqueness_dimensions}
\alias{uniqueness_dimensions}
\title{Uniqueness dimensions}
\usage{
uniqueness_dimensions(pres_matrix, traits_table, ...)
}
\arguments{
\item{pres_matrix}{a site-species matrix, with species in rows and sites
in columns, containing presence-absence, relative abundances or
abundances values}

\item{traits_table}{a data.frame of traits with species in row and traits in
columns, \strong{row names} should be \strong{species names},}

\item{...}{additional arguments supplied to \code{\link[=compute_dist_matrix]{compute_dist_matrix()}}}
}
\value{
a data.frame containing species' names and their uniqueness values
for each traits (\strong{Ui_X} column for trait \strong{X}), as well as a
column for the uniqueness value for all traits (\strong{Ui_all} column)
}
\description{
From a trait table and a site-species matrix compute Uniqueness
(nearest functional distance) for each species and each trait, plus computes
it for all the traits.
}
\examples{
data("aravo", package = "ade4")

# Site-species matrix
mat = as.matrix(aravo$spe)
rel_mat = make_relative(mat)

# Example of trait table
tra = aravo$traits[, c("Height", "SLA", "N_mass")]

ui_dim = uniqueness_dimensions(rel_mat, tra)

}
\seealso{
\code{\link[=distinctiveness_dimensions]{distinctiveness_dimensions()}}, \code{\link[=uniqueness]{uniqueness()}}, \code{\link[=uniqueness_stack]{uniqueness_stack()}}
and \code{\link[=compute_dist_matrix]{compute_dist_matrix()}} for additional arguments
}
