% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_fmotif}
\alias{plot_fmotif}
\title{Plot as boxplot mean performances
of assemblages sorted by assembly motifs}
\usage{
plot_fmotif(fres, nbcl = 0, main = "Title", opt.motif = NULL )
}
\arguments{
\item{fres}{an object generated by the function \code{\link{fclust}}.}

\item{nbcl}{an integer.
The integer indicates the number of component clusters
to take into account.
It can be lower than or equals to
the optimum number \code{fres$nbOpt} of component clusters.}

\item{main}{a string, that is used
as the first, reference part of the title of each graph.}

\item{opt.motif}{a list, that can include
\code{opt.motif = list("obs", "cal", "prd", cols, "hor", "ver", "seq",
pvalue, "all")}.
This option list manages the plot of mean performances
of assembly motifs as boxplots,
observed, modelled or predicted by cross-validation,
horizontally or vertically,
sorted by increasing or decreasing mean values,
from \code{1} to \code{nbOpt} clusters of components.
The item order in list is any. \cr

\itemize{
 \item{\code{"obs", "cal", "prd":}}{  plot the observed,
   modelled or predicted by cross-validation mean performances
   of assembly motifs as boxplots.
   Assembly motifs are named as the combinations of component clusters
   (see "opt.tree").
   The coloured squares are the mean performances of assembly motifs.
   Size (number of observed assemblages) of assembly motifs
   is indicated on the left of boxplots.
   The red dashed line is the mean performance of assembly motifs.
   If \code{"aov"} is checked, groups significantly different
   (at a p-value < \code{pvalue}) are indicated by differents letters
   on the right of boxplots.
   }

\item{\code{"hor":}}{  plot boxplots as horizontal boxes:
  x-axis corresponds to assemblage performances,
  and y-axis corresponds to assembly motifs.
  It \code{"hor"} is not checked,
  boxplots are plotted as vertical boxes:
  x-axis corresponds to assembly motifs,
  and y-axis corresponds to assemblage performances.
  Option "ver" can also be used: "ver" = !"hor".
  }

\item{\code{"seq":}}{  plot mean performances of assembly motifs,
  from \code{2} to \code{nbOpt} number of component clusters.
  Remember that number \code{m} of assembly motifs increases
  with the number \code{nbcl} of component clusters
  (\code{m = 2^nbcl - 1}). When the optimal number
  of component clusters is large,
  this option is useful to determine
  a number of component clusters lower
  than the optimal number of component clusters.
  Assembly motifs are named as the combinations of component clusters
  (see "opt.tree").
  }

\item{\code{pvalue = value:}}{  a probability used as threshold
  in the variance analysis. Then \code{pvalue} must be
  higher than \code{0} and lower than \code{1}.
  \code{pvalue} must be informed when \code{"aov"} is checked.
  Groups significantly different
  (at a p-value < \code{pvalue}) are then indicated by differents letters
  on the right of boxplots.
  }

\item{\code{"all":}}{  plot all possible graphs.
  This option is equivalent to
  \code{opt.motif = list("obs", "cal", "prd", "seq",
  "aov", pvalue = 0.001)}.
  }¶
}}
}
\value{
Nothing. It is a procedure.
}
\description{
The function plots, as vertical or horizontal boxplots,
composition and mean performance sorted by assembly motifs.
}
\details{
None.
}
\seealso{
\code{\link{plot_ftrees}} plot primary and secondary trees
 resulting from functional clustering \cr
\code{\link{plot_fperf}} plot observed, modelled and predicted performances
 resulting from functional clustering \cr
\code{\link{plot_fass}} plot performances of some given assemblages \cr
\code{\link{plot_fmotif}} plot as boxplot mean performances
of assemblages sorted by assembly motifs \cr
\code{\link{plot_fcomp}} plot as boxplot mean performances
of assemblages containing a given component \cr
\code{\link{fclust_plot}} plot all possible outputs
of functional clustering
}
\keyword{internal}
