% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmc_utils.R
\name{bmc_search}
\alias{bmc_search}
\title{Search for gene sequences available for a species from NCBI.}
\usage{
bmc_search(query, limit = 10, offset = 1, key = NULL, ...)
}
\arguments{
\item{query}{Search terms.}

\item{limit}{Number of records to return. Default 10.}

\item{offset}{Record number to start at. Default: 1}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A list of length 2
}
\description{
Search for gene sequences available for a species from NCBI.
}
\examples{
\dontrun{
bmc_search(query='ecology')
bmc_search('fire', limit=3)
bmc_search('fire', limit=2, page=1)
bmc_search('fire', limit=2, page=2)

# Search, then get full text
out <- bmc_search('ecology')
(urls <- vapply(out$records$url, "[[", "", 'value'))
browseURL(urls[1])

# curl debugging help
bmc_search('ecology', verbose = TRUE)
}
}
\keyword{internal}
