% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pdfx.R
\name{pdfx}
\alias{pdfx}
\alias{pdfx_html}
\alias{pdfx_targz}
\title{PDF-to-XML conversion of scientific articles using pdfx}
\usage{
pdfx(file, what = "parsed", ...)

pdfx_html(input, ...)

pdfx_targz(input, write_path, ...)
}
\arguments{
\item{file}{(character) Path to a file, or files on your machine. Required.}

\item{what}{(character) One of parsed or text.}

\item{...}{Further args passed to \code{\link[httr]{GET}}. These aren't named, so just do e.g. ,
\code{verbose()}, or \code{timeout(3)}}

\item{input}{Output from \code{pdfx} function}

\item{write_path}{Path to write tar ball to.}
}
\value{
\code{pdfx} gives XML parsed to \code{xml_document}, \code{pdfx_html}
gives html, \code{pdfx_targz} writes a tar.gz file to disk.
}
\description{
Uses a web service provided by Utopia at
\url{http://pdfx.cs.man.ac.uk/}. Beware, this can be quite slow.
\code{pdfx} posts the pdf from your machine to the web service,
\code{pdfx_html} takes the output of \code{pdfx} and gives back
a html version of extracted text, and \code{pdfx_targz}
gives a tar.gz version of the extracted text. This will not work
with PDFs that are scans of text, or mostly of images.
}
\examples{
\dontrun{
path <- system.file("examples", "example2.pdf", package = "fulltext")
pdfx(file = path)

out <- pdfx(file = path)
pdfx_html(out)

out <- pdfx(file = path)
tarfile <- tempfile(fileext = "tar.gz")
pdfx_targz(input = out, write_path = tarfile)
}
}

