% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_io.R
\name{read.md.subjects}
\alias{read.md.subjects}
\title{Read subjects file}
\usage{
read.md.subjects(subjects_file, header = FALSE)
}
\arguments{
\item{subjects_file, }{string. The path to the file.}

\item{header, }{logical. Whether the file starts with a header line. Defaults to FALSE.}
}
\value{
a vector of strings. The subject IDs.
}
\description{
Load a list of subjects from a subjects file, i.e., a simple text file containing one subject name per line.
}
\examples{
   subjects_file = system.file("extdata", "subjects.txt", package = "fsbrain", mustWork = TRUE);
   subjects_list = read.md.subjects(subjects_file);

}
\seealso{
Other metdata functions: 
\code{\link{read.md.demographics}()}
}
\concept{metdata functions}
