% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_agg.R
\name{group.morph.agg.native}
\alias{group.morph.agg.native}
\title{Aggregate native space morphometry data over one hemisphere for a group of subjects.}
\usage{
group.morph.agg.native(subjects_dir, subjects_list, measure, hemi,
  agg_fun = mean, cast = TRUE, format = "curv")
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subjects_list, }{string vector. A vector of subject identifiers that match the directory names within subjects_dir.}

\item{measure, }{string. Name of the vertex-wise measure of morphometry data file. E.g., "area" or "thickness". Used to construct the name of the morphometry file to be loaded.}

\item{hemi, }{string, one of 'lh', 'rh' or 'both'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{agg_fun, }{function. An R function that aggregates data, typically max, mean, min or something similar. Note: this is NOT a string, put the function name without quotes. Defaults to mean.}

\item{cast, }{logical. Whether the format of the returned data frame should be cast, i.e., whether a separate 'hemi' column should be introduced. If this is set to FALSE, the following will be returned: a dataframe with 2 columns and n rows, where n is the number of subjects. The 2 columns are 'subject_id' and '<hemi>.<measure>' (e.g., "lh.thickness"), the latter contains the aggregated data. See the description of the return value for the default case (cast=TRUE). Defaults to TRUE.}

\item{format, }{string. One of 'mgh', 'mgz', 'curv'. Defaults to 'curv'.}
}
\value{
dataframe with aggregated values for all subjects, with 3 columns and n rows, where n is the number of subjects. The 3 columns are 'subject_id', 'hemi', and '<measure>' (e.g., "thickness"), the latter contains the aggregated data.
}
\description{
Compute the mean (or other aggregates) over all vertices of a subject from native space morphometry data (like 'surf/lh.area'). Uses knowledge about the FreeSurfer directory structure to load the correct file.
}
\seealso{
Other global aggregation functions: \code{\link{group.morph.agg.standard}},
  \code{\link{group.multimorph.agg.native}},
  \code{\link{group.multimorph.agg.standard}}
}
\concept{global aggregation functions}
