% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fsEnsemble}
\alias{fsEnsemble}
\title{Ensemble feature selection for MTS}
\usage{
fsEnsemble(feature.sets, threshold, method = c("ranking", "majority"))
}
\arguments{
\item{feature.sets}{a list of matrixes that contains weights for features, estimated by several feature selection algorithms (base learners)}

\item{threshold}{the required sparsity of the resulting feature set}

\item{method}{a ensemble learning algorithm.
Implemented algorithms:
\itemize{
 \item{\strong{"ranking"}}{ - individual feature sets are ranked according to their weights
 and further the sum of ranks is used for feature selection (\emph{threshold} share of features is selected).
 The algorithm uses ranking of feature with a minor priority to earlier lags and even smaller priority to order of MTS components.
 So, if features of 1st  and 2nd lags have identical weights, the feature of the 1st lag will be preferred;
 if features of the same lag have identical weights, the order of features is used as a priority.
 }
 \item{\strong{"majority"}}{ - base feature sets are for feature selection (\emph{threshold} share of features is selected)
 and further the resulting feature set is estimated using majority voting (50 or more percent of base learners)
 }
}}
}
\value{
returns a binary feature matrix.
Columns correpond to components of the time series; rows correspond to lags.
}
\description{
\code{fsEnsemble} implements methods for ensemble learning of features for multivariate time series
}
\examples{

# Load traffic data
data(traffic.mini)

# Scaling is sometimes useful for feature selection
# Exclude the first column - it contains timestamps
data <- scale(traffic.mini$data[,-1])

mIndep<-fsMTS(data, max.lag=3, method="ownlags")
mCCF<-fsMTS(data, max.lag=3, method="CCF")
mDistance<-fsMTS(data, max.lag=3, method="distance", shortest = traffic.mini$shortest, step = 5)
mGLASSO<-fsMTS(data, max.lag=3,method="GLASSO", rho = 0.05)
mLARS<-fsMTS(data, max.lag=3,method="LARS")
mRF<-fsMTS(data, max.lag=3,method="RF")
mMI<-fsMTS(data, max.lag=3,method="MI")
mlist <- list(Independent = mIndep,
              Distance = mDistance,
              CCF = mCCF,
              GLASSO = mGLASSO,
              LARS = mLARS,
              RF = mRF,
              MI = mMI)


th<-0.30
mlist[["EnsembleRank"]] <- fsEnsemble(mlist, threshold = th, method="ranking")
mlist[["EnsembleMajV"]] <- fsEnsemble(mlist, threshold = th, method="majority")
(msimilarity <- fsSimilarityMatrix(mlist,threshold = th, method="Kuncheva"))

}
\references{
Pes, B., 2019. Ensemble feature selection for high-dimensional data: a stability analysis across multiple domains. Neural Computing and Applications. https://doi.org/10.1007/s00521-019-04082-3
}
