% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderate_wind.R
\name{moderate_wind}
\alias{moderate_wind}
\title{Estimation of the daily hours with moderate wind from
daily weather data}
\usage{
moderate_wind(climdata)
}
\arguments{
\item{climdata}{a dataframe with daily wind speed data.
Required columns are Year, Month, Day and u2med. u2max
is an optional data column.}
}
\value{
dataframe with the columns Date, Year, Month, Day, DOY,
and h_wind (hours with wind speed equal or above 5.5 m/s).
}
\description{
This function estimates the daily hours with wind speed equal or
above than 'moderate breeze' wind (5.5 m s-1 in the Beaufort scale)
from a dataset with daily wind speeds. Hourly wind speeds
from daily values are computed using the formulas proposed
by Guo et al (2016), using mean daily values (u2med, required)
and maximum ones (u2max, optional). If only mean wind values
are available, the function uses a modified version of the 
Guo formula, so that the maximum values are obtained in 
daytime hours.
}
\examples{

# Estimate daily hours with wind speed above moderate speeds for the example
# dataset
library(tidyverse)
library(lubridate)
Tudela_Mu2 <- moderate_wind(Tudela_DW)

}
\references{
Guo Z, Chang C, Wang R, 2016. A novel method to downscale daily wind
statistics to hourly wind data for wind erosion modelling. In: Bian F.,
Xie Y. (eds) Geo-Informatics in Resource Management and Sustainable
Ecosystem. GRMSE 2015. Communications in Computer and Information Science,
vol 569. Springer, Berlin, Heidelberg
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
