% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bs4dash.R
\name{bs4Dash-sidebar}
\alias{bs4Dash-sidebar}
\alias{bs4dash_sidebar_light}
\alias{bs4dash_sidebar_dark}
\title{bs4Dash sidebar skins light/dark}
\usage{
bs4dash_sidebar_light(
  bg = NULL,
  hover_bg = NULL,
  color = NULL,
  hover_color = NULL,
  active_color = NULL,
  submenu_bg = NULL,
  submenu_color = NULL,
  submenu_hover_color = NULL,
  submenu_hover_bg = NULL,
  submenu_active_color = NULL,
  submenu_active_bg = NULL,
  header_color = NULL
)

bs4dash_sidebar_dark(
  bg = NULL,
  hover_bg = NULL,
  color = NULL,
  hover_color = NULL,
  active_color = NULL,
  submenu_bg = NULL,
  submenu_color = NULL,
  submenu_hover_color = NULL,
  submenu_hover_bg = NULL,
  submenu_active_color = NULL,
  submenu_active_bg = NULL,
  header_color = NULL
)
}
\arguments{
\item{bg}{Background color.}

\item{hover_bg}{Hover background color.}

\item{color}{Color.}

\item{hover_color}{Hover color.}

\item{active_color}{Active color.}

\item{submenu_bg}{Submenu background color.}

\item{submenu_color}{Submenu color.}

\item{submenu_hover_color}{Submenu hover color.}

\item{submenu_hover_bg}{Submenu hover background color.}

\item{submenu_active_color}{Submenu active color.}

\item{submenu_active_bg}{Submenu active background color.}

\item{header_color}{Header color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
bs4Dash sidebar skins light/dark
}
\examples{

# Change colors used in bs4Dash
bs4dash_sidebar_light(
  bg = "#D7DF01",
  color = "#FF0000",
  active_color = "#00FF00",
  submenu_bg = "#00FFFF"
)

if (interactive()) {

  library(shiny)
  library(bs4Dash)

  ui <- bs4DashPage(
    title = "bs4Dash Custom Sidebar",
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(
      title = "bs4Dash Custom Sidebar",
      skin = "light",
      bs4SidebarHeader("Sidebar Title"),
      bs4SidebarMenu(
        bs4SidebarMenuItem(
          tabName = "menu1",
          text = "Menu 1",
          icon = "home"
        ),
        bs4SidebarMenuItem(
          tabName = "menu2",
          text = "Menu 2",
          icon = "th"
        ),
        bs4SidebarMenuItem(
          text = "Item List",
          icon = "bars",
          startExpanded = TRUE,
          bs4SidebarMenuSubItem(
            text = "Item 1",
            tabName = "item1",
            icon = "circle-thin"
          ),
          bs4SidebarMenuSubItem(
            text = "Item 2",
            tabName = "item2",
            icon = "circle-thin"
          )
        )
      )
    ),
    body = bs4DashBody(
      use_theme(create_theme(
        bs4dash_sidebar_light(
          bg = "#D7DF01",
          color = "#FF0000",
          active_color = "#00FF00",
          submenu_bg = "#00FFFF"
        )
      ))
    )
  )

  server <- function(input, output) {

  }

  shinyApp(ui, server)

}

}
