% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_updates.R
\name{fredr_series_updates}
\alias{fredr_series_updates}
\title{Get a set of recently updated FRED series}
\usage{
fredr_series_updates(
  ...,
  filter_value = NULL,
  start_time = NULL,
  end_time = NULL,
  limit = NULL,
  offset = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{...}{These dots only exist for future extensions and should be empty.}

\item{filter_value}{Filter results by type of geographic region of economic
the data series.  Possible values include
\itemize{
\item \code{"all"} (default) - no filtering
\item \code{"macro"} - filters results macroeconomic regions (e.g. entire countries)
\item \code{"regional"} - filters results to series for regions of the United States
such as states, counties, and Metropolitan Statistical Areas (MSA).
}}

\item{start_time}{A datetime object indicating the start time to filter series
updates results.}

\item{end_time}{A datetime object indicating the start time to filter series
updates results.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object where each row represents a series. Rows are sorted
with most recently updated series appearing first.
}
\description{
Returns information on the recently updated series on the FRED server.
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/series_updates.html}{fred/series/updates}
}

\examples{
if (fredr_has_key()) {
# Get all recently updated "regional" series
fredr_series_updates(filter_value = "regional")
# Most recently udpated series are returned first
updates <- fredr_series_updates(filter_value = "regional")$last_updated
is.unsorted(rev(as.POSIXct(updates)))
}
}
\seealso{
\code{\link[=fredr_series_observations]{fredr_series_observations()}}, \code{\link[=fredr_series_search_text]{fredr_series_search_text()}},
\code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_series]{fredr_series()}},
\code{\link[=fredr_series_release]{fredr_series_release()}}, \code{\link[=fredr_series_tags]{fredr_series_tags()}}, \code{\link[=fredr_series_categories]{fredr_series_categories()}},
\code{\link[=fredr_series_vintagedates]{fredr_series_vintagedates()}}.
}
