% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_glance.R
\name{database_glance}
\alias{database_glance}
\title{Obtain tidy summary information for a floristic quality database}
\usage{
database_glance(database)
}
\arguments{
\item{database}{A database downloaded from
\href{https://universalfqa.org/}{universalfqa.org} either manually or using
\code{\link[=download_database]{download_database()}}}
}
\value{
A data frame with 8 columns:
\itemize{
   \item region (character)
   \item year (numeric)
   \item description (character)
   \item total_species (numeric)
   \item native_species (numeric)
   \item non_native_species (numeric)
   \item total_mean_c (numeric)
   \item native_mean_c (numeric)
}
}
\description{
\code{database_glance()} tidies a floristic quality database obtained from
\href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
# While database_glance can be used with a .csv file downloaded manually
# from the universal FQA website, it is most typically used in combination
# with download_database().

chicago_db <- download_database(database_id = 1)
chicago_db_summary <- database_glance(chicago_db)

}
