% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpaccess.R
\name{Fpop}
\alias{Fpop}
\title{Fpop}
\usage{
Fpop(x, lambda, mini = min(x), maxi = max(x))
}
\arguments{
\item{x}{a numerical vector to segment}

\item{lambda}{the penalty per changepoint (see Maidstone et al. 2016)}

\item{mini}{minimum mean segment value to consider in the optimisation.}

\item{maxi}{maximum mean segment value to consider in the optimisation.}
}
\value{
return a list with a vector t.est containing the position of the change-points, the number of changes K and, the cost J.est.
}
\description{
Function to run the Fpop algorithm (Maidstone et al. 2016). It uses functional pruning and optimal partionning. It optimizes the L2-loss for a penalty lambda per change.
}
\examples{
x <- c(rnorm(100), rnorm(10^3)+2, rnorm(1000)+1)
est.sd <- sdDiff(x) ## rough estimate of std-deviation
res <- Fpop(x=x,lambda=2*est.sd^2*log(length(x)))
smt <- getSMT(res)
}
