% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explanations.R
\name{visualizeInstance}
\alias{visualizeInstance}
\title{Visualization of a data instance using a set of barplots}
\usage{
visualizeInstance(data, instanceIndex, bars = 10)
}
\arguments{
\item{data}{data.frame with data describing all instances}

\item{instanceIndex}{index of the instance to visualize}

\item{bars}{max number of bars to plot, only top lowest and top highest frequencies will be presented}
}
\description{
Visualization of a data instance using a set of barplots
}
\examples{
library("fpmoutliers")
dataFrame <- read.csv(
     system.file("extdata", "fp-outlier-customer-data.csv", package = "fpmoutliers"))
model <- FPI(dataFrame, minSupport = 0.001)
# sort data by the anomaly score
dataFrame <- dataFrame[order(model$scores, decreasing = TRUE),]
visualizeInstance(dataFrame, 1) # instance with the highest anomaly score
visualizeInstance(dataFrame, nrow(dataFrame)) # instance with the lowest anomaly score
}
