% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arh_rkhs.R
\name{arh_rkhs}
\alias{arh_rkhs}
\title{Autoregressive Hilbertian Model using RKHS}
\usage{
arh_rkhs(fdata)
}
\arguments{
\item{fdata}{an fdata object containing the functional objects and the
lambda coefficients of the d dimensional RKHS representation.}
}
\value{
\item{fdata}{smoothed curves.} \item{lambda_cent}{centered
coefficients of the d dimensional RKHS representation.}
\item{lambda_ce}{average coefficients of the d dimensional RKHS
representation.} \item{rho}{autocorrelation operator computed as:
\eqn{Gamma_0}\eqn{Psi} = \eqn{Gamma_1}. \eqn{Gamma_0} correspond to the
Covariance and \eqn{Gamma_0} correspond to the Cross-Covariance (of lag 1)
operators, both estimated using the coefficients \eqn{lambda}.}
}
\description{
Estimates an autoregresive Hilbertian model of order 1 for functional time
series. The temporal dependence is estimated in the Hilbert projection space
which has a reproducing kernel as proposed in Hernández et al (2021) <arXiv:2105.13627> and
Wang et al (2020) <arXiv:2011.13993>.
}
\references{
N. Hernández, J. Cugliari, J. Jacques. Simultaneous Predictive
Bands for Functional Time Series using Minimum Entropy Sets. arXiv:2105.13627 (2021).
D. Wang, Z. Zhao, R. Willett, C. Y. Yau, Functional
autoregressive processes in reproducing kernel hilbert spaces, arXiv
preprint arXiv:2011.13993 (2020).
}
\author{
N. Hernández and J. Cugliari
}
