% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_math.R
\name{op_formula}
\alias{op_formula}
\alias{multiply_formula}
\alias{divide_formula}
\alias{add_formula}
\alias{subtract_formula}
\alias{Ops.formula}
\alias{Math.formula}
\title{Perform a mathematical operation on two formula}
\usage{
op_formula(op, e1, e2)

multiply_formula(e1, e2)

divide_formula(e1, e2)

add_formula(e1, e2)

subtract_formula(e1, e2)

\method{Ops}{formula}(e1, e2)

\method{Math}{formula}(x, ...)
}
\arguments{
\item{op}{The operation to perform either as a name or something that can be
coerced into a name.}

\item{e1, e2, x}{The formulae to operate on}

\item{...}{Ignored.}
}
\value{
\code{e1} and \code{e2} combined by the operation with the
  environment from \code{e1}.  See Details.
}
\description{
Perform a mathematical operation on two formula
}
\details{
The method for combination depends if the two formula are one- or
  two-sided.

If both formula are one-sided, the right hand side (RHS) of both are added
together with additional parentheses added, if parentheses appear to be
needed.  If both formula are two-sided, the left hand side (LHS) and RHS are
separately added.  If one formula is one-sided and the other is two-sided,
the LHS is selected from the two-sided formula and the RHS follows rules as
though two one-sided formula were added.

\code{multiply_formula} Multiply two formula (identical to \code{(a~b) * (c~d)}

\code{divide_formula} Divide two formula (identical to \code{(a~b) / (c~d)}

\code{add_formula} Add two formula (identical to \code{(a~b) + (c~d)}

\code{subtract_formula} Multiply two formula (identical to \code{(a~b) - (c~d)}

\code{Ops.formula} Supports generic binary operators and a couple of
  unary operators (see ?Ops).

\code{Math.formula} Supports generic unary operators (see ?Math).
}
\examples{
op_formula("+", a~b, c~d)
op_formula("+", a~b, ~d)
op_formula("+", ~b, c~d)
op_formula("+", ~b, ~d)
op_formula("-", a~b)
op_formula("-", -a~b) # Dumb, but accurate
op_formula("-", -a~b, c~-d) # Dumb, but accurate

log(a~b)
}
