% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTestIDMarkers.R
\name{simTestIDMarkers}
\alias{simTestIDMarkers}
\title{Simulate testID markers}
\usage{
simTestIDMarkers(ped, testID, numSim = 10, seed = 123457)
}
\arguments{
\item{ped}{pedigree}

\item{testID}{test ID}

\item{numSim}{number of simulations}

\item{seed}{seed}
}
\value{
list of simulations
}
\description{
Simulate testID markers
}
\examples{
library(forrel)
library(mispitools)
freqs <- lapply(getfreqs(Argentina)[1:15], function(x) {x[x!=0]})
fam  <- linearPed(2)
fam  <- addChildren(fam, father =  1, mother =  2)
fam  <- pedtools::setMarkers(fam, locusAttributes = freqs)
ped  <- profileSim(fam, N = 1, ids = c(6)  , numCores = 1,seed=123)
lsimEnsemble  <- simTestIDMarkers(ped,2,numSim=5,seed=123)
}
