% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{plot.thetam}
\alias{plot.thetam}
\title{Plot components from Theta model}
\usage{
\method{plot}{thetam}(x, ...)
}
\arguments{
\item{x}{Object of class "thetam".}

\item{...}{Other plotting parameters passed through to \code{plot}}
}
\value{
None.  Function produces a plot.
}
\description{
Produces a plot of the level components from the ETS model underlying a Theta model
}
\details{
The "state" component of the plot comes from the model \code{ets(..., model = "ANN")} that
was fit as part of the theta method.  The "seasonal" component is the multipliers from multiplicative classical 
decomposition seasonal adjustment that is performed before the \code{ets} model is fit.  The "linear"
component shows the direction and slope of drift that is used in the forecasting to come.
}
\examples{
model <- thetam(wineind)
plot(model)
}
\author{
Peter Ellis
}
\seealso{
\code{\link{thetam}}
}

