% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{predict.fm}
\alias{predict.fm}
\title{Forecasting for factor models}
\usage{
\method{predict}{fm}(object, x, h = 1, fc.restricted = TRUE, r = c("ic", "er"), ...)
}
\arguments{
\item{object}{\code{fm} object}

\item{x}{input time series matrix, with each row representing a variable}

\item{h}{forecasting horizon}

\item{fc.restricted}{whether to forecast using a restricted or unrestricted, blockwise VAR representation of the common component}

\item{r}{number of restricted factors, or a string specifying the factor number selection method when \code{fc.restricted = TRUE};
 possible values are:
\itemize{
   \item{\code{"ic"}}{ information criteria of Alessi, Barigozzi & Capasso (2010)}
   \item{\code{"er"}}{ eigenvalue ratio}
}}

\item{...}{not used}
}
\value{
a list containing
\item{is}{ in-sample predictions}
\item{forecast}{ forecasts for the given forecasting horizon}
\item{r}{ factor number}
}
\description{
Produces forecasts of the data for a given forecasting horizon by
estimating the best linear predictors of the common component
}
\references{
Ahn, S. C. & Horenstein, A. R. (2013) Eigenvalue ratio test for the number of factors. Econometrica, 81(3), 1203--1227.

Alessi, L., Barigozzi, M.,  & Capasso, M. (2010) Improved penalization for determining the number of factors in approximate factor models. Statistics & Probability Letters, 80(23-24):1806–1813.

Barigozzi, M., Cho, H. & Owens, D. (2022) Factor-adjusted network estimation and forecasting for high-dimensional time series. arXiv preprint arXiv:2201.06110.

Owens, D., Cho, H. & Barigozzi, M. (2022) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling
}
\seealso{
\link[fnets]{fnets.factor.model}, \link[fnets]{common.predict}
}
