% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callerFunctions.R
\name{callNewtonBFGSLInitC}
\alias{callNewtonBFGSLInitC}
\title{Optimize MLE objective for smooth a log-concave density}
\usage{
callNewtonBFGSLInitC(X, w, params, ACVH, bCVH)
}
\arguments{
\item{X}{Set of data points (one sample per row)}

\item{w}{Vector of sample weights}

\item{params}{Vector of initial hyperplane parameters}

\item{ACVH}{Matrix where each row constitutes the normal vector of a face of
conv(X)}

\item{bCVH}{Vector where each entry constitutes the offset for a face of
conv(X)}
}
\value{
List containing the optimal parameters as well as the log likelihood
  \item{params}{Stacked vector of hyperplane slopes and offsets}
  \item{logLike}{Vector containing function evaluations log(f(x_i))}
}
\description{
\code{callNewtonBFGSLInitC} is similar as \code{callNewtonBFGSLC}
  but optimizies a smooth log-concave density f(x) with parameter gamma=1. Due to
  numerical reasons a different set of C functions is used.
}
