% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{geom_fm}
\alias{geom_fm}
\alias{geom_fm.fm_mesh_2d}
\alias{geom_fm.fm_segm}
\alias{geom_fm.fm_mesh_1d}
\title{ggplot2 geomes for fmesher related objects}
\usage{
geom_fm(mapping = NULL, data = NULL, ...)

\method{geom_fm}{fm_mesh_2d}(
  mapping = NULL,
  data = NULL,
  ...,
  mappings = NULL,
  defs = NULL,
  crs = NULL,
  mapping_int = deprecated(),
  mapping_bnd = deprecated(),
  defs_int = deprecated(),
  defs_bnd = deprecated()
)

\method{geom_fm}{fm_segm}(mapping = NULL, data = NULL, ..., crs = NULL)

\method{geom_fm}{fm_mesh_1d}(
  mapping = NULL,
  data = NULL,
  ...,
  mappings = NULL,
  defs = NULL,
  xlim = NULL,
  basis = TRUE,
  knots = TRUE,
  derivatives = FALSE,
  weights = NULL
)
}
\arguments{
\item{mapping}{\code{\link[ggplot2:aes]{ggplot2::aes()}} mapping information.}

\item{data}{an object for which to generate a geom.}

\item{...}{Arguments passed on to the geom method.}

\item{mappings, defs}{optional lists of \code{aes} mappings and non-\code{aes} settings.
For \code{fm_mesh_2d}, the non-triangle parts of
the mesh, named "int" for interior constraint edges, "bnd" for boundary
edges, and "loc" for the vertices. For \code{fm_mesh_1d}, the elements are
"knots" and "fun".}

\item{crs}{Optional crs to transform the object to before plotting.}

\item{mapping_int, mapping_bnd, defs_int, defs_bnd}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} arguments; see \code{mappings} and \code{defs}.}

\item{xlim}{numeric 2-vector; specifies the interval for which to compute
functions. Default is \code{data$interval}}

\item{basis}{logical; if \code{TRUE} (default), show the spline basis functions}

\item{knots}{logical; if \code{TRUE} (default), show the spline knot locations}

\item{derivatives}{logical; if \code{TRUE} (not default), draw first order
derivatives instead of function values}

\item{weights}{numeric vector; if provided, draw weighted basis functions and
the resulting weighted sum.}
}
\value{
A combination of \code{ggplot2} geoms.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{geom_fm} is a generic function for generating geomes from various kinds of
\code{fmesher} objects, e.g. \code{fm_segm} and \code{fm_mesh_2d}.
The function invokes particular methods which depend
on the \link{class} of the \code{data} argument.
Requires the \code{ggplot2} package.

Note: \code{geom_fm} is not yet a "proper" \code{ggplot2} geom method; the interface
may therefore change in the future.
}
\section{Methods (by class)}{
\itemize{
\item \code{geom_fm(fm_mesh_2d)}: Converts an \code{\link[=fm_mesh_2d]{fm_mesh_2d()}} object to \code{sf} with \code{\link[=fm_as_sfc]{fm_as_sfc()}} and uses
\code{geom_sf} to visualize the triangles and edges.

The mesh vertices are only plotted if \code{mappings$loc} or \code{defs$loc}
is non-\code{NULL}, e.g. \code{defs = list(loc = list())}. Default argument settings:

\if{html}{\out{<div class="sourceCode">}}\preformatted{... = linewidth = 0.25, color = "grey" # default for triangle mapping
defs = list(
  int = list(linewidth = 0.5, color = "blue"),
  bnd = list(linewidth = 1, color = "black", alpha = 0),
  loc = list(size = 1, color = "red")
)
}\if{html}{\out{</div>}}

\item \code{geom_fm(fm_segm)}: Converts an \code{\link[=fm_segm]{fm_segm()}} object to \code{sf} with \code{\link[=fm_as_sfc]{fm_as_sfc()}} and uses
\code{geom_sf} to visualize it.

\item \code{geom_fm(fm_mesh_1d)}: Evaluates and plots the basis functions defined by an \code{\link[=fm_mesh_1d]{fm_mesh_1d()}} object.

}}
\examples{
\dontshow{if (require("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ggplot() +
  geom_fm(data = fmexample$mesh)
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- fm_mesh_2d(
  cbind(10, 20),
  boundary = fm_extensions(cbind(10, 20), c(25, 65)),
  max.edge = c(4, 10),
  crs = fm_crs("+proj=longlat")
)
ggplot() +
  geom_fm(data = m)
ggplot() +
  geom_fm(data = m, defs = list(loc = list()))
ggplot() +
  geom_fm(data = m, crs = fm_crs("epsg:27700"))
\donttest{
# Compute a mesh vertex based function on a different grid
px <- fm_pixels(
  fm_transform(m, fm_crs("mollweide_globe")),
  dims = c(50, 50) # Speed up the example by lowering the resolution
)
px$fun <- fm_evaluate(m,
  loc = px,
  field = sin(m$loc[, 1] / 5) * sin(m$loc[, 2] / 5)
)
ggplot() +
  geom_tile(aes(geometry = geometry, fill = fun),
    data = px,
    stat = "sf_coordinates"
  ) +
  geom_fm(
    data = m, alpha = 0.2, linewidth = 0.05,
    crs = fm_crs("mollweide_globe")
  )
}
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m1 <- fm_segm(rbind(c(1, 2), c(4, 3), c(2, 4)), is.bnd = TRUE)
m2 <- fm_segm(rbind(c(2, 2), c(3, 4), c(2, 3)), is.bnd = FALSE)
ggplot() +
  geom_fm(data = m1) +
  geom_fm(data = m2)
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- fm_mesh_1d(
  c(1, 2, 3, 5, 7),
  boundary = c("dirichlet", "neumann"),
  degree = 2
)
ggplot() +
  geom_fm(data = m)
\dontshow{\}) # examplesIf}
}
