% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifold.R
\name{fm_manifold}
\alias{fm_manifold}
\alias{fm_manifold_type}
\alias{fm_manifold_dim}
\title{Query the mesh manifold type}
\usage{
fm_manifold(x, type = NULL)

fm_manifold_type(x)

fm_manifold_dim(x)
}
\arguments{
\item{x}{An object with \code{manifold} information, or a character string}

\item{type}{\code{character}; if \code{NULL} (the default), returns the manifold definition string.
If \code{character}, returns \code{TRUE} if the manifold type of \code{x} matches at least
one of the character vector elements.}
}
\value{
\code{fm_manifold()}: Either logical (matching manifold type yes/no),
or character (the stored manifold, when \code{is.null(type)} is \code{TRUE})

\code{fm_manifold_type()}: character or NULL; "M", "R", "S", or "T"

\code{fm_manifold_dim()}: integer or NULL
}
\description{
Extract a manifold definition string, or a logical for matching
manifold type
}
\examples{
fm_manifold(fmexample$mesh)
fm_manifold_type(fmexample$mesh)
fm_manifold_dim(fmexample$mesh)
}
