% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currency-pair-class.R
\name{CurrencyPairMethods}
\alias{CurrencyPairMethods}
\alias{is_t1}
\alias{to_spot}
\alias{to_spot_next}
\alias{to_forward}
\alias{to_today}
\alias{to_tomorrow}
\alias{to_fx_value}
\alias{invert}
\title{CurrencyPair methods}
\usage{
is_t1(x)

to_spot(dates, x)

to_spot_next(dates, x)

to_forward(dates, tenor, x)

to_today(dates, x)

to_tomorrow(dates, x)

to_fx_value(dates, tenor, x)

invert(x)
}
\arguments{
\item{x}{a \code{CurrencyPair} object}

\item{dates}{a vector of dates from which forward dates are calculated}

\item{tenor}{the tenor of the value date which can be one of the following:
"spot", "spot_next", "today", "tomorrow" and the usual "forward" dates (e.g.
\code{lubridate::months(3)})}
}
\description{
A collection of methods related to currency pairs.
}
\details{
The methods are summarised as follows:
\itemize{
\item \code{is_t1}: Returns \code{TRUE} if the currency pair settles one good day after
trade. This includes the following currencies crossed with the USD: CAD, TRY,
PHP, RUB, KZT and PKR
\item \code{to_spot}: The spot dates are usually two non-NY good day after today.
\code{is_t1()} identifies the pairs whose spot dates are conventionally one good
non-NYC day after today. In both cases, if those dates are not a good NYC
day, they are rolled to good NYC and non-NYC days using the Following
convention.
\item \code{to_spot_next}: The spot next dates are one good NYC and non-NYC day after
spot rolled using the Following convention if necessary.
\item \code{to_forward}: Forward dates are determined using the calendar's \code{shift()}
method rolling bad NYC and non-NYC days using the Following convention. The
end-to-end convention applies.
\item \code{to_today}: Today is simply dates which are good NYC and non-NYC days.
Otherwise today is undefined and returns \code{NA}.
\item \code{to_tomorrow}: Tomorrow is one good NYC and non-NYC day except where that
is on or after spot. In that case, is is undefined and returns \code{NA}.
\item \code{to_value}: Determine common value dates. The supported value date \code{tenors}
are: "spot", "spot_next", "today", "tomorrow" and the usual
"forward" dates (e.g. \code{lubridate::months(3)}).
\item \code{invert}: Inverts the currency pair and returns new \code{CurrencyPair} object.
\item \code{is.CurrencyPair}:  Returns \code{TRUE} if \code{x} inherits from the \code{CurrencyPair}
class; otherwise \code{FALSE}
}
}
\examples{
library(lubridate)
is_t1(AUDUSD())
dts <- lubridate::ymd(20170101) + lubridate::days(0:30)
to_spot(dts, AUDUSD())
to_spot_next(dts, AUDUSD())
to_today(dts, AUDUSD())
to_tomorrow(dts, AUDUSD())
to_fx_value(dts, months(3), AUDUSD())
}
