% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_rda.R
\name{export_rda}
\alias{export_rda}
\title{Write RDA files}
\usage{
export_rda(..., file, FUN = save, data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), dir = flyio_get_dir(),
  delete_file = TRUE)
}
\arguments{
\item{...}{R ojects need to be saved}

\item{file}{path of the file to be written to}

\item{FUN}{the function using which the file is to write}

\item{data_source}{the name of the data source, if not set globally. s3, gcs or local}

\item{bucket}{the name of the bucket, if not set globally}

\item{dir}{the directory to store intermediate files}

\item{delete_file}{logical. to delete the file to be uploaded}
}
\value{
No output
}
\description{
Write R data RDA file to anywhere from R
}
\examples{
\dontrun{
# save RDA on Google Cloud Storage
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
export_rda(iris, mtcars, "rda-on-cloud.rda", dir = tempdir())
}
}
