% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-sample-ci.R
\name{two_sample_ci}
\alias{two_sample_ci}
\title{Two-Sample Permutation Confidence Interval}
\usage{
two_sample_ci(
  null_specification,
  x,
  y,
  alpha = 0.05,
  statistic = stat_hotelling,
  B = 1000L,
  alternative = "right_tail",
  type = "exact",
  point_estimate = NULL,
  lower_bound = 0,
  upper_bound = 1,
  seed = NULL
)
}
\arguments{
\item{null_specification}{A function with two arguments \code{y} and \code{parameters}
such that \verb{F_X = F_\{null_specification(Y, parameters)\}} under the null
hypothesis.}

\item{x}{A list or matrix representing the 1st sample.}

\item{y}{A list or matrix representing the 2nd sample.}

\item{alpha}{A scalar specifying the desired significance level. Default is
\code{0.05}.}

\item{statistic}{A character vector specifying the chosen test statistic(s).
These can be \code{\link{stat_hotelling}} or user-specified functions that
define desired statistics. See the section \emph{User-supplied statistic
function} for more information on how these user-supplied functions should
be structured for compatibility with the \strong{flipr} framwork. Default is
\code{\link{stat_hotelling}}.}

\item{B}{The number of sampled permutation. Default is \code{1000L}.}

\item{alternative}{A string specifying whether the p-value is right-tailed,
left-tailed or two-tailed. Choices are \code{"right_tail"}, \code{"left_tail"} and
\code{"two_tail"}. Default is \code{"right_tail"}. Obviously, if the test statistic
used in argument \code{statistic} is positive, all alternatives will lead to the
two-tailed p-value.}

\item{type}{A string specifying if performing an exact test through the use
of Phipson-Smyth estimate of the p-value or an approximate test through a
Monte-Carlo estimate of the p-value. Default is \code{"exact"}.}

\item{point_estimate}{A scalar providing a point estimate of the parameter
under investigation. Default is \code{NULL}, in which case the point estimate is
computed by maximizing the p-value function via the
\code{\link{two_sample_pe}} function.}

\item{lower_bound}{A scalar value specifying a rough lower bound of the
interval over which searching the maximum of the p-value function. Default
is \code{0}.}

\item{upper_bound}{A scalar value specifying a rough upper bound of the
interval over which searching the maximum of the p-value function. Default
is \code{1}.}

\item{seed}{An integer specifying the seed of the random generator useful for
result reproducibility or method comparisons. Default is \code{NULL}.}
}
\value{
A length-2 vector providing the confidence interval at the required
level.
}
\description{
This function calculates permutation confidence intervals for two-sample
problems. This is done through the specification a point estimate of the
parameter to be estimated and of a set of null hypotheses of the form \verb{F_X = F_\{g(Y, parameters)\}} where \code{g} is a user-supplied function.
}
\examples{
x1 <- rnorm(10)
x2 <- rnorm(10, 3)
null_spec <- function(y, parameters) {y - parameters[1]}
two_sample_ci(
  null_specification = null_spec,
  x = x1,
  y = x2,
  statistic = stat_t,
  alternative = "two_tail",
  lower_bound = 2,
  upper_bound = 4,
  B = 100L
)
}
