% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-sample-pf.R
\name{two_sample_pf}
\alias{two_sample_pf}
\title{Two-Sample Permutation P-Value Function}
\usage{
two_sample_pf(
  parameters,
  null_specification,
  x,
  y,
  statistic = stat_hotelling,
  B = 1000L,
  alternative = "right_tail",
  combine_with = "tippett",
  type = "exact",
  seed = NULL
)
}
\arguments{
\item{parameters}{A list of vectors specifying a set of candidate parameter
values under the null hypothesis.}

\item{null_specification}{A function with two arguments \code{y} and \code{parameters}
such that \verb{F_X = F_\{null_specification(Y, parameters)\}} under the null
hypothesis.}

\item{x}{A list or matrix representing the 1st sample.}

\item{y}{A list or matrix representing the 2nd sample.}

\item{statistic}{A character vector specifying the chosen test statistic(s).
These can be \code{\link{stat_hotelling}} or user-specified functions that
define desired statistics. See the section \emph{User-supplied statistic
function} for more information on how these user-supplied functions should
be structured for compatibility with the \strong{flipr} framwork. Default is
\code{\link{stat_hotelling}}.}

\item{B}{The number of sampled permutation. Default is \code{1000L}.}

\item{alternative}{A string specifying whether the p-value is right-tailed,
left-tailed or two-tailed. Choices are \code{"right_tail"}, \code{"left_tail"} and
\code{"two_tail"}. Default is \code{"right_tail"}. Obviously, if the test statistic
used in argument \code{statistic} is positive, all alternatives will lead to the
two-tailed p-value.}

\item{combine_with}{A string specifying the combining function to be used to
compute the single test statistic value from the set of p-value estimates
obtained during the non-parametric combination testing procedure. Default
is \code{"tippett"}, which picks Tippett's function.}

\item{type}{A string specifying if performing an exact test through the use
of Phipson-Smyth estimate of the p-value or an approximate test through a
Monte-Carlo estimate of the p-value. Default is \code{"exact"}.}

\item{seed}{An integer specifying the seed of the random generator useful for
result reproducibility or method comparisons. Default is \code{NULL}.}
}
\value{
A vector of p-values of the permutation test for each parameter
values specified through the first argument.
}
\description{
This function calculates the permutation p-value function for two-sample
problems. This is done through the specification of a set of null hypotheses
of the form \verb{F_X = F_\{g(Y, parameters)\}} where \code{g} is a user-supplied
function.
}
\examples{
x1 <- rnorm(10)
x2 <- rnorm(10, 3)
null_spec <- function(y, parameters) {y - parameters[1]}
two_sample_pf(
  parameters = 3,
  null_specification = null_spec,
  x = x1,
  y = x2,
  statistic = stat_t,
  seed = 1234,
  B = 1000,
  alternative = "two_tail"
)
}
