% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_airfares.R
\name{download_airfares_data}
\alias{download_airfares_data}
\title{Download and read ANAC air fares data}
\usage{
download_airfares_data(
  file_url = parent.frame()$file_url,
  showProgress = parent.frame()$showProgress,
  select = parent.frame()$select
)
}
\arguments{
\item{file_url}{String. A url passed from \code{\link{get_flights_url}}.}

\item{showProgress}{Logical, passed from \code{\link{read_flights}}}

\item{select}{A vector of column names or numbers to keep, passed from \code{\link{read_flights}}}
}
\value{
A \verb{"data.table" "data.frame"} object
}
\description{
Download and read ANAC air fares data
}
\examples{
\dontrun{ if (interactive()) {
# Generate url
file_url <- get_airfares_url(dom = TRUE, year=2002, month=11)

# download data
a <- download_airfares_data(file_url=file_url, showProgress=TRUE, select=NULL)
}}
}
\keyword{internal}
