% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_airport_movements.R
\name{read_airport_movements}
\alias{read_airport_movements}
\title{Download airport movement data from Brazil}
\usage{
read_airport_movements(date = 202001, showProgress = TRUE)
}
\arguments{
\item{date}{Numeric. Date of the data in the format \code{yyyymm}. Defaults to
\code{202001}. To download the data for all months in a year, the user
can pass a 4-digit year input \code{yyyy}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress.}
}
\value{
A \verb{"data.table" "data.frame"} object. All columns are returned with
\code{class} of type \code{"character"}.
}
\description{
Download airport movements data from Brazil’s Civil Aviation Agency (ANAC).
The data covers all passenger, aircraft, cargo and mail movement data from
airports regulated by ANAC. Data only available from Jan 2019 onwards. A
description of all variables included in the data is available at
\url{https://www.anac.gov.br/acesso-a-informacao/dados-abertos/areas-de-atuacao/operador-aeroportuario/operador-aeroportuario-dados-de-movimentacao-aeroportuaria/metadados-do-conjunto-de-dados-dados-de-movimentacao-aeroportuaria}.
}
\examples{
\dontrun{ if (interactive()) {
# Read airport movement data
amov202006 <- read_airport_movements(date = 202006)

amov2020 <- read_airport_movements(date = 2020)
}}
}
\concept{download airport movement data}
