library(tidyr)

context("test flatten_table_list")

test_that("flatten_table_list works", {
  result <-
    structure(
      list(
        page = c(
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M1",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M2",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M3",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4",
          "M4"
        ),
        col1 = c(
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a1",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2",
          "a2"
        ),
        col2 = c(
          "b1",
          "b1",
          "b1",
          "b1",
          "b2",
          "b2",
          "b2",
          "b3",
          "b3",
          "b1",
          "b1",
          "b1",
          "b1",
          "b2",
          "b2",
          "b2",
          "b2",
          "b3",
          "b3",
          "b3",
          "b3",
          "b1",
          "b1",
          "b1",
          "b1",
          "b2",
          "b2",
          "b2",
          "b3",
          "b3",
          "b1",
          "b1",
          "b1",
          "b1",
          "b2",
          "b2",
          "b2",
          "b2",
          "b3",
          "b3",
          "b3",
          "b3",
          "b1",
          "b1",
          "b1",
          "b1",
          "b2",
          "b2",
          "b2",
          "b3",
          "b3",
          "b1",
          "b1",
          "b1",
          "b1",
          "b2",
          "b2",
          "b2",
          "b2",
          "b3",
          "b3",
          "b3",
          "b3",
          "b1",
          "b1",
          "b1",
          "b1",
          "b2",
          "b2",
          "b2",
          "b3",
          "b3",
          "b1",
          "b1",
          "b1",
          "b1",
          "b2",
          "b2",
          "b2",
          "b2",
          "b3",
          "b3",
          "b3",
          "b3"
        ),
        row1 = c(
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e1",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e1",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e1",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e1",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2",
          "e1",
          "e1",
          "e2",
          "e2"
        ),
        row2 = c(
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d1",
          "d1",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d1",
          "d1",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d1",
          "d1",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d1",
          "d1",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2",
          "d1",
          "d2"
        ),
        value = c(
          "2.99",
          "1.02",
          "4.06",
          "1.32",
          "3.89",
          "3.65",
          "5.55",
          "2.33",
          "1.87",
          "5.62",
          "1.94",
          "4.59",
          "2.13",
          "3.82",
          "7.72",
          "4.78",
          "2.94",
          "5.36",
          "6.38",
          "1.69",
          "1.78",
          "12",
          "12",
          "31",
          "7",
          "26",
          "37",
          "19",
          "6",
          "28",
          "50",
          "23",
          "46",
          "16",
          "42",
          "18",
          "33",
          "5",
          "30",
          "24",
          "25",
          "13",
          "35.88",
          "12.24",
          "64.88",
          "9.24",
          "54.70",
          "52.31",
          "54.25",
          "13.98",
          "52.36",
          "111.70",
          "44.62",
          "105.66",
          "34.08",
          "65.92",
          "70.78",
          "74.62",
          "14.70",
          "70.32",
          "71.52",
          "42.25",
          "23.14",
          "442.52",
          "150.96",
          "1223.64",
          "69.96",
          "970.96",
          "964.57",
          "586.75",
          "93.20",
          "1473.56",
          "3533.70",
          "1034.02",
          "2455.20",
          "553.80",
          "1561.52",
          "687.32",
          "1927.10",
          "85.26",
          "1268.08",
          "1135.90",
          "1063.01",
          "307.94"
        )
      ),
      row.names = c(NA,-84L),
      class = c("tbl_df", "tbl",
                "data.frame")
    )

  f <- function(pt) {
    pt %>%
      set_page(1, 1) %>%
      define_labels(n_col = 2, n_row = 2) %>%
      remove_top(1) %>%
      fill_labels() %>%
      remove_agg() %>%
      fill_values() %>%
      remove_k() %>%
      replace_dec() %>%
      unpivot()
  }

  ft <- flatten_table_list(list_pt_ie, f)
  ft <- dplyr::arrange(ft, page, col1, col2, row1, row2)
  result <- dplyr::arrange(result, page, col1, col2, row1, row2)

  expect_equal(ft, result)
})
